/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.resources;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.introspection.Extension;
import org.mule.extension.resources.GeneratedResource;
import org.mule.extension.resources.ResourcesGenerator;
import org.mule.extension.resources.spi.GenerableResourceContributor;
import org.mule.module.extension.internal.resources.DefaultGeneratedResource;

public abstract class AbstractResourcesGenerator
implements ResourcesGenerator {
    private Map<String, GeneratedResource> resources = new HashMap<String, GeneratedResource>();
    private ServiceRegistry serviceRegistry;

    public AbstractResourcesGenerator(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public GeneratedResource get(String filepath) {
        GeneratedResource resource = this.resources.get(filepath);
        if (resource == null) {
            resource = new DefaultGeneratedResource(filepath);
            this.resources.put(filepath, resource);
        }
        return resource;
    }

    public void generateFor(Extension extension) {
        for (GenerableResourceContributor contributor : this.serviceRegistry.lookupProviders(GenerableResourceContributor.class, this.getClass().getClassLoader())) {
            contributor.contribute(extension, (ResourcesGenerator)this);
        }
    }

    public List<GeneratedResource> dumpAll() {
        ImmutableList.Builder generatedResources = ImmutableList.builder();
        for (GeneratedResource resource : this.resources.values()) {
            generatedResources.add((Object)resource);
            this.write(resource);
        }
        return generatedResources.build();
    }

    protected abstract void write(GeneratedResource var1);
}

