/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import javax.inject.Inject;
import org.mule.api.MuleMessage;
import org.mule.api.serialization.DefaultObjectSerializer;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.api.serialization.SerializationException;
import org.mule.api.transport.SessionHandler;
import org.mule.util.store.DeserializationPostInitialisable;

public abstract class AbstractSessionHandler
implements SessionHandler {
    private ObjectSerializerLocator objectSerializerLocator = new FromMessageObjectSerializerLocator();

    protected <T> T deserialize(MuleMessage message, byte[] bytes) {
        Object object = this.objectSerializerLocator.getObjectSerializer(message).deserialize(bytes, message.getMuleContext().getExecutionClassLoader());
        if (object instanceof DeserializationPostInitialisable) {
            try {
                DeserializationPostInitialisable.Implementation.init(object, message.getMuleContext());
            }
            catch (Exception e) {
                throw new SerializationException("Could not initialise session after deserialization", (Throwable)e);
            }
        }
        return object;
    }

    protected byte[] serialize(MuleMessage message, Object object) {
        return this.objectSerializerLocator.getObjectSerializer(message).serialize(object);
    }

    @Inject
    @DefaultObjectSerializer
    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializerLocator = new FixedObjectSerializerLocator(objectSerializer);
    }

    private class FromMessageObjectSerializerLocator
    implements ObjectSerializerLocator {
        private FromMessageObjectSerializerLocator() {
        }

        @Override
        public ObjectSerializer getObjectSerializer(MuleMessage message) {
            return message.getMuleContext().getObjectSerializer();
        }
    }

    private class FixedObjectSerializerLocator
    implements ObjectSerializerLocator {
        private final ObjectSerializer objectSerializer;

        private FixedObjectSerializerLocator(ObjectSerializer objectSerializer) {
            this.objectSerializer = objectSerializer;
        }

        @Override
        public ObjectSerializer getObjectSerializer(MuleMessage message) {
            return this.objectSerializer;
        }
    }

    private static interface ObjectSerializerLocator {
        public ObjectSerializer getObjectSerializer(MuleMessage var1);
    }
}

