/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.io.InputStream;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.util.IOUtils;

public class ClobResolvedDataType
extends ResolvedDbType {
    public ClobResolvedDataType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value) throws SQLException {
        if (value != null && !(value instanceof Clob)) {
            Clob clob = statement.getConnection().createClob();
            if (value instanceof String) {
                clob.setString(1L, (String)value);
            } else if (value instanceof InputStream) {
                clob.setString(1L, IOUtils.toString((InputStream)((InputStream)value)));
            } else {
                throw new IllegalArgumentException(ClobResolvedDataType.createUnsupportedTypeErrorMessage(value));
            }
            value = clob;
        }
        super.setParameterValue(statement, index, value);
    }

    protected static String createUnsupportedTypeErrorMessage(Object value) {
        return String.format("Cannot create a Clob from a value of type '%s'", value.getClass());
    }
}

