/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.result.statement;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.param.OutputQueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.result.resultset.ResultSetHandler;
import org.mule.module.db.internal.result.resultset.ResultSetProcessingException;
import org.mule.module.db.internal.result.statement.AutoGeneratedKeysProcessingException;
import org.mule.module.db.internal.result.statement.OutputParamProcessingException;
import org.mule.module.db.internal.result.statement.OutputParamResult;
import org.mule.module.db.internal.result.statement.ResultSetResult;
import org.mule.module.db.internal.result.statement.StatementResult;
import org.mule.module.db.internal.result.statement.UpdateCountResult;

public class StatementResultIterator
implements Iterator<StatementResult> {
    public static final int NO_UPDATE_COUNT = -1;
    private final Log logger = LogFactory.getLog(StatementResultIterator.class);
    private final Statement statement;
    private final QueryTemplate queryTemplate;
    private final AutoGeneratedKeyStrategy autoGeneratedKeyStrategy;
    private final DbConnection connection;
    private final ResultSetHandler resultSetHandler;
    private final int outputParamsSize;
    private Boolean cachedResult = null;
    private ResultSet resultSet;
    private int updateCount;
    private int currentOutputParam;
    private int updateCountIndex = 1;
    private int resultSetIndex = 1;
    private boolean isFirstInvocation = true;
    private ResultSet generatedKeys;
    private boolean processedGeneratedKeyResultSet;
    private boolean hasProcessedResultSet;

    public StatementResultIterator(DbConnection connection, Statement statement, QueryTemplate queryTemplate, AutoGeneratedKeyStrategy autoGeneratedKeyStrategy, ResultSetHandler resultSetHandler) {
        this.statement = statement;
        this.queryTemplate = queryTemplate;
        this.autoGeneratedKeyStrategy = autoGeneratedKeyStrategy;
        this.connection = connection;
        this.resultSetHandler = resultSetHandler;
        this.outputParamsSize = queryTemplate.getOutputParams().size();
        this.currentOutputParam = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.cachedResult != null) {
            return this.cachedResult;
        }
        try {
            if (!this.isFirstInvocation) {
                if (!this.processedGeneratedKeyResultSet) {
                    if (this.retrieveAutoGeneratedKeys()) {
                        this.generatedKeys = this.statement.getGeneratedKeys();
                        this.processedGeneratedKeyResultSet = true;
                    } else {
                        this.processedGeneratedKeyResultSet = true;
                    }
                }
                if (this.generatedKeys == null) {
                    this.moveToNextResult();
                }
            } else {
                this.isFirstInvocation = false;
            }
            if (this.generatedKeys != null) {
                this.cachedResult = true;
                return true;
            }
            this.resultSet = this.statement.getResultSet();
            if (this.resultSet != null) {
                this.cachedResult = true;
                return true;
            }
            this.updateCount = this.statement.getUpdateCount();
            if (this.updateCount != -1) {
                this.cachedResult = true;
                return true;
            }
            this.cachedResult = this.currentOutputParam < this.outputParamsSize;
            return this.cachedResult;
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Unable to determine if there are more statement results", (Throwable)e);
            return false;
        }
    }

    protected boolean retrieveAutoGeneratedKeys() {
        return this.autoGeneratedKeyStrategy.returnsAutoGeneratedKeys();
    }

    @Override
    public StatementResult next() {
        StatementResult result;
        if (this.cachedResult == null) {
            this.hasNext();
        }
        this.cachedResult = null;
        if (this.resultSet != null) {
            result = this.processResultSet();
            this.hasProcessedResultSet = true;
            this.resultSet = null;
        } else if (this.updateCount != -1) {
            result = this.doProcessUpdateCount("updateCount" + this.updateCountIndex++, this.updateCount);
            this.updateCount = -1;
        } else if (this.generatedKeys != null) {
            result = this.processGeneratedKeys();
            this.generatedKeys = null;
        } else if (this.currentOutputParam < this.outputParamsSize) {
            result = this.processOutputParam();
            ++this.currentOutputParam;
        } else {
            throw new NoSuchElementException();
        }
        return result;
    }

    private StatementResult processGeneratedKeys() {
        StatementResult generatedKeysResult;
        try {
            generatedKeysResult = this.doProcessResultSet("generatedKeys", this.generatedKeys);
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Unable to obtain auto generated keys", (Throwable)e);
            throw new AutoGeneratedKeysProcessingException(e);
        }
        return generatedKeysResult;
    }

    private void moveToNextResult() throws SQLException {
        if (this.connection.getMetaData().supportsMultipleOpenResults()) {
            this.statement.getMoreResults(2);
        } else {
            if (this.hasProcessedResultSet && this.resultSetHandler.requiresMultipleOpenedResults()) {
                throw new IllegalStateException("Database does not supports streaming of resultSets on stored procedures");
            }
            this.statement.getMoreResults();
        }
    }

    protected StatementResult processOutputParam() {
        OutputQueryParam outputSqlParam = this.queryTemplate.getOutputParams().get(this.currentOutputParam);
        try {
            Object paramValue = outputSqlParam.getType().getParameterValue((CallableStatement)this.statement, outputSqlParam.getIndex());
            return this.doProcessOutputParam(outputSqlParam, paramValue);
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Unable to obtain output parameter", (Throwable)e);
            throw new OutputParamProcessingException(e);
        }
    }

    protected StatementResult doProcessOutputParam(OutputQueryParam outputSqlParam, Object paramValue) throws SQLException {
        if (paramValue instanceof ResultSet) {
            paramValue = this.resultSetHandler.processResultSet(this.connection, (ResultSet)paramValue);
        } else if (paramValue instanceof SQLXML) {
            SQLXML sqlxml = (SQLXML)paramValue;
            paramValue = sqlxml.getString();
        }
        return new OutputParamResult(outputSqlParam.getName(), paramValue);
    }

    protected StatementResult doProcessUpdateCount(String name, int value) {
        return new UpdateCountResult(name, value);
    }

    private StatementResult processResultSet() {
        StatementResult result;
        String name = "resultSet" + this.resultSetIndex++;
        try {
            result = this.doProcessResultSet(name, this.resultSet);
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Unable to obtain next resultSet", (Throwable)e);
            throw new ResultSetProcessingException("Error processing result set: " + name, e);
        }
        return result;
    }

    protected StatementResult doProcessResultSet(String name, ResultSet resultSet) throws SQLException {
        Object handledResultSet = this.resultSetHandler.processResultSet(this.connection, resultSet);
        return new ResultSetResult(name, handledResultSet);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

