/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.transformers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.ArrayUtils;

public class FileToByteArray
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public FileToByteArray() {
        this.registerSourceType(DataTypeFactory.create(File.class));
        this.registerSourceType(DataTypeFactory.create(FileInputStream.class));
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
    }

    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        File file = null;
        FileInputStream fileInputStream = null;
        if (src instanceof FileInputStream) {
            fileInputStream = (FileInputStream)src;
        } else if (src instanceof File) {
            file = (File)src;
            if (file == null) {
                throw new TransformerException((Transformer)this, (Throwable)new IllegalArgumentException("null file"));
            }
            if (!file.exists()) {
                throw new TransformerException((Transformer)this, (Throwable)new FileNotFoundException(file.getPath()));
            }
            if (file.length() == 0L) {
                this.logger.warn((Object)("File is empty: " + file.getAbsolutePath()));
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
        } else {
            throw new TransformerException(MessageFactory.createStaticMessage((String)"Cannot handle source type %s", (Object[])new Object[]{src.getClass().getName()}), (Transformer)this);
        }
        try {
            byte[] e = IOUtils.toByteArray((InputStream)fileInputStream);
            return e;
        }
        catch (OutOfMemoryError oom) {
            throw new TransformerException((Transformer)this, (Throwable)oom);
        }
        catch (IOException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

