/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;
import org.raml.yagi.framework.util.DateType;
import org.raml.yagi.framework.util.DateUtils;

public class DateValueRule
extends Rule {
    private DateType dateType;
    private String rfc = "rfc3339";

    public DateValueRule(DateType dateType, String rfc) {
        this.dateType = dateType;
        if (rfc != null) {
            this.rfc = rfc;
        }
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            if (DateUtils.isValidDate(((StringNode)node).getValue(), this.dateType, this.rfc)) {
                return node;
            }
            return ErrorNodeFactory.createInvalidDateValue(((StringNode)node).getValue(), this.dateType.name(), this.rfc);
        }
        return ErrorNodeFactory.createInvalidNode(node);
    }

    @Override
    public String getDescription() {
        return "Multiple of value";
    }
}

