/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.SecurityUtils;

public class TlsConfigurationTestCase
extends AbstractMuleTestCase {
    private static final String SUPPORTED_CIPHER_SUITE = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA";
    private static final String SUPPORTED_PROTOCOL = "TLSv1.1";
    private static final String TEST_SECURITY_MODEL = "test";

    @Test
    public void emptyConfiguration() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        try {
            configuration.initialise(false, "javax.net");
            Assert.fail((String)"no key password");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        configuration.setKeyPassword("mulepassword");
        try {
            configuration.initialise(false, "javax.net");
            Assert.fail((String)"no store password");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        configuration.setKeyStorePassword("mulepassword");
        configuration.setKeyStore("");
        try {
            configuration.initialise(false, "javax.net");
            Assert.fail((String)"no keystore");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void simpleSocket() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        configuration.setKeyPassword("mulepassword");
        configuration.setKeyStorePassword("mulepassword");
        configuration.setKeyStore("clientKeystore");
        configuration.initialise(false, "javax.net");
        SSLSocketFactory socketFactory = configuration.getSocketFactory();
        Assert.assertThat((Object)socketFactory.getSupportedCipherSuites(), (Matcher)Matchers.not((Matcher)Matchers.arrayWithSize((int)0)));
    }

    @Test
    public void exceptionOnInvalidKeyAlias() throws Exception {
        URL keystoreUrl = this.getClass().getClassLoader().getResource("serverKeystore");
        File keystoreFile = new File(keystoreUrl.toURI());
        TlsConfiguration config = new TlsConfiguration(keystoreFile.getAbsolutePath());
        config.setKeyStorePassword("mulepassword");
        config.setKeyPassword("mulepassword");
        config.setKeyAlias("this_key_does_not_exist_in_the_keystore");
        try {
            config.initialise(false, "javax.net");
        }
        catch (CreateException ce) {
            Assert.assertThat((Object)ce.getCause(), (Matcher)IsInstanceOf.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void cipherSuitesFromEnabledProtocols() throws Exception {
        TlsConfiguration tlsConfiguration = new TlsConfiguration(".keystore");
        tlsConfiguration.initialise(true, "javax.net");
        this.testPropertiesFrom(this.createDefaultConfigFile(true), tlsConfiguration.getSslContext().getSupportedSSLParameters().getCipherSuites());
    }

    @Test
    public void cipherSuitesFromConfigFile() throws Exception {
        this.testPropertiesFrom(this.createDefaultConfigFile(false), new String[]{SUPPORTED_CIPHER_SUITE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropertiesFrom(File configFile, String[] supportedCipherSuites) throws Exception {
        try {
            TlsConfiguration tlsConfiguration = new TlsConfiguration(".keystore");
            tlsConfiguration.initialise(true, "javax.net");
            SSLSocket socket = (SSLSocket)tlsConfiguration.getSocketFactory().createSocket();
            SSLServerSocket serverSocket = (SSLServerSocket)tlsConfiguration.getServerSocketFactory().createServerSocket();
            Assert.assertThat((Object)socket.getEnabledCipherSuites(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])supportedCipherSuites));
            Assert.assertThat((Object)serverSocket.getEnabledCipherSuites(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])supportedCipherSuites));
        }
        finally {
            FileUtils.deleteFile((File)configFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void protocolsFromConfigFile() throws Exception {
        File configFile = this.createDefaultConfigFile(false);
        try {
            TlsConfiguration tlsConfiguration = new TlsConfiguration(".keystore");
            tlsConfiguration.initialise(true, "javax.net");
            SSLSocket socket = (SSLSocket)tlsConfiguration.getSocketFactory().createSocket();
            SSLServerSocket serverSocket = (SSLServerSocket)tlsConfiguration.getServerSocketFactory().createServerSocket();
            Assert.assertThat((Object)socket.getEnabledProtocols(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{SUPPORTED_PROTOCOL}));
            Assert.assertThat((Object)serverSocket.getEnabledProtocols(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{SUPPORTED_PROTOCOL}));
        }
        finally {
            FileUtils.deleteFile((File)configFile);
        }
    }

    @Test
    public void defaultProtocol() throws Exception {
        TlsConfiguration tlsConfiguration = new TlsConfiguration(".keystore");
        tlsConfiguration.initialise(true, "javax.net");
        SSLSocketFactory socketFactory = tlsConfiguration.getSocketFactory();
        SSLServerSocketFactory serverSocketFactory = tlsConfiguration.getServerSocketFactory();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, null, null);
        Assert.assertThat((Object)socketFactory.getDefaultCipherSuites(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])sslContext.getSocketFactory().getDefaultCipherSuites()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void defaultProtocolFromConfigFile() throws Exception {
        File configFile = this.getDefaultProtocolConfigFile();
        try {
            TlsConfiguration tlsConfiguration = new TlsConfiguration(".keystore");
            tlsConfiguration.initialise(true, "javax.net");
            SSLSocketFactory socketFactory = tlsConfiguration.getSocketFactory();
            SSLServerSocketFactory serverSocketFactory = tlsConfiguration.getServerSocketFactory();
            SSLContext sslContext = SSLContext.getInstance(SUPPORTED_PROTOCOL);
            sslContext.init(null, null, null);
            SSLSocketFactory protocolSocketFactory = sslContext.getSocketFactory();
            SSLServerSocketFactory protocolServerSocketFactory = sslContext.getServerSocketFactory();
            Assert.assertThat((Object)socketFactory.getDefaultCipherSuites(), (Matcher)Matchers.arrayWithSize((int)protocolSocketFactory.getDefaultCipherSuites().length));
            Assert.assertThat((Object)socketFactory.getDefaultCipherSuites(), (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])protocolSocketFactory.getDefaultCipherSuites())));
            Assert.assertThat((Object)serverSocketFactory.getDefaultCipherSuites(), (Matcher)Matchers.arrayWithSize((int)protocolServerSocketFactory.getDefaultCipherSuites().length));
            Assert.assertThat((Object)serverSocketFactory.getDefaultCipherSuites(), (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])protocolServerSocketFactory.getDefaultCipherSuites())));
        }
        finally {
            FileUtils.deleteFile((File)configFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void overrideDefaultProtocolFromConfigFile() throws Exception {
        File configFile = this.getDefaultProtocolConfigFile();
        try {
            TlsConfiguration tlsConfiguration = new TlsConfiguration(".keystore");
            tlsConfiguration.setSslType("TLSv1.2");
            tlsConfiguration.initialise(true, "javax.net");
            SSLSocketFactory socketFactory = tlsConfiguration.getSocketFactory();
            SSLContext sslContext = SSLContext.getInstance(SUPPORTED_PROTOCOL);
            sslContext.init(null, null, null);
            SSLSocketFactory protocolSocketFactory = sslContext.getSocketFactory();
            Assert.assertThat((Object)socketFactory.getDefaultCipherSuites(), (Matcher)Matchers.not((Matcher)Matchers.arrayWithSize((int)protocolSocketFactory.getDefaultCipherSuites().length)));
        }
        finally {
            FileUtils.deleteFile((File)configFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void securityModelProperty() throws Exception {
        String previousSecurityModel = SecurityUtils.getSecurityModel();
        System.setProperty("mule.security.model", TEST_SECURITY_MODEL);
        File file = this.createConfigFile(TEST_SECURITY_MODEL, "enabledCipherSuites=TEST");
        try {
            TlsConfiguration tlsConfiguration = new TlsConfiguration(".keystore");
            tlsConfiguration.initialise(true, "javax.net");
            Assert.assertThat((Object)tlsConfiguration.getEnabledCipherSuites(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"TEST"}));
        }
        finally {
            System.setProperty("mule.security.model", previousSecurityModel);
            FileUtils.deleteFile((File)file);
        }
    }

    @Test
    public void testTlsConfigurationDoesNotLeakKeyStoreFile() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        configuration.setKeyPassword("mulepassword");
        configuration.setKeyStorePassword("mulepassword");
        configuration.setKeyStore("clientKeystore");
        configuration.initialise(false, "javax.net");
        URL keystoreUrl = this.getClass().getClassLoader().getResource("clientKeystore");
        File keyStoreFile = FileUtils.newFile((URI)keystoreUrl.toURI());
        Assert.assertThat((Object)FileUtils.isFileOpen((File)keyStoreFile), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testTlsConfigurationDoesNotLeakTrustStoreFile() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        configuration.setKeyPassword("mulepassword");
        configuration.setKeyStorePassword("mulepassword");
        configuration.setKeyStore("clientKeystore");
        configuration.setTrustStorePassword("mulepassword");
        configuration.setTrustStore("trustStore");
        configuration.initialise(false, "javax.net");
        URL keystoreUrl = this.getClass().getClassLoader().getResource("trustStore");
        File trustStoreFile = FileUtils.newFile((URI)keystoreUrl.toURI());
        Assert.assertThat((Object)FileUtils.isFileOpen((File)trustStoreFile), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testTlsConfigurationUsingPKCS12KeystoreWithMultipleKeys() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        configuration.setKeyPassword("passw0rd");
        configuration.setKeyStorePassword("passw0rd");
        configuration.setKeyStore("keystoreMultiplesKeys.p12");
        configuration.setKeyStoreType("pkcs12");
        configuration.setKeyAlias("ldnmulvs01");
        configuration.initialise(false, "javax.net");
        SSLSocketFactory socketFactory = configuration.getSocketFactory();
        Assert.assertThat((Object)socketFactory.getSupportedCipherSuites().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    private File getDefaultProtocolConfigFile() throws IOException {
        return this.createConfigFile("default", String.format("defaultProtocol=%s", SUPPORTED_PROTOCOL));
    }

    private File createDefaultConfigFile(boolean onlyEnabledProtocols) throws IOException {
        String contents = onlyEnabledProtocols ? String.format("enabledProtocols=%s", SUPPORTED_PROTOCOL) : String.format("enabledCipherSuites=UNSUPPORTED,%s\nenabledProtocols=UNSUPPORTED,%s", SUPPORTED_CIPHER_SUITE, SUPPORTED_PROTOCOL);
        return this.createConfigFile("default", contents);
    }

    private File createConfigFile(String securityModel, String contents) throws IOException {
        String path = ClassUtils.getClassPathRoot(this.getClass()).getPath();
        File file = new File(path, String.format("tls-%s.conf", securityModel));
        PrintWriter writer = new PrintWriter(file, "UTF-8");
        writer.println(contents);
        writer.close();
        return file;
    }
}

