/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.context.notification;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.context.notification.ExceptionStrategyNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.processor.MessageProcessor;
import org.mule.context.notification.ExceptionStrategyNotification;
import org.mule.exception.CatchMessagingExceptionStrategy;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class NotificationThreadAccessTestCase
extends AbstractMuleContextTestCase {
    private final CountDownLatch exceptionLatch = new CountDownLatch(1);
    private final CatchMessagingExceptionStrategy exceptionStrategy = new CatchMessagingExceptionStrategy();

    @Test
    public void raceConditionForThreadOwnership() throws Exception {
        muleContext.getNotificationManager().addInterfaceToType(ExceptionStrategyNotificationListener.class, ExceptionStrategyNotification.class);
        muleContext.getNotificationManager().addListener((ServerNotificationListener)new ExceptionStrategyNotificationListener(){

            public void onNotification(ServerNotification notification) {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        ((ThreadSafeAccess)notification.getSource()).resetAccessControl();
                    }
                    catch (Throwable e) {
                        NotificationThreadAccessTestCase.this.exceptionLatch.countDown();
                    }
                }
            }
        });
        MuleEvent event = NotificationThreadAccessTestCase.getTestEvent(null);
        MessageProcessor threadAccessMessageProcessor = new MessageProcessor(){

            public MuleEvent process(final MuleEvent event) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (!Thread.currentThread().isInterrupted()) {
                            try {
                                ThreadSafeAccess threadSafeAccess = (ThreadSafeAccess)event;
                                threadSafeAccess.resetAccessControl();
                            }
                            catch (Throwable e) {
                                NotificationThreadAccessTestCase.this.exceptionLatch.countDown();
                            }
                        }
                    }
                }).start();
                return event;
            }
        };
        this.exceptionStrategy.setMessageProcessors(Arrays.asList(threadAccessMessageProcessor));
        this.exceptionStrategy.setMuleContext(muleContext);
        this.exceptionStrategy.initialise();
        this.exceptionStrategy.handleException((Exception)new RuntimeException("TestException"), event);
        Assert.assertThat((String)"An exception caused by a race condition for getting the message ownership was triggered", (Object)this.exceptionLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)false));
    }
}

