/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.execution;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.AnnotatedObject;
import org.mule.api.execution.LocationExecutionContextProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class LocationExecutionContextProviderTestCase
extends AbstractMuleTestCase {
    @Mock
    private AnnotatedObject annotatedObject;

    @Test
    public void sanitizedUrl() {
        this.withXmlElement(this.annotatedObject, "<sftp:outbound-endpoint url=\"sftp://muletest:muletest@localhost:22198/~/testdir");
        String sanitized = LocationExecutionContextProvider.getSourceXML((AnnotatedObject)this.annotatedObject);
        Assert.assertThat((Object)sanitized, (Matcher)CoreMatchers.equalTo((Object)"<sftp:outbound-endpoint url=\"sftp://<<credentials>>@localhost:22198/~/testdir"));
    }

    @Test
    public void sanitizedAddress() {
        this.withXmlElement(this.annotatedObject, "<sftp:outbound-endpoint address=\"sftp://muletest:muletest@localhost:22198/~/testdir");
        String sanitized = LocationExecutionContextProvider.getSourceXML((AnnotatedObject)this.annotatedObject);
        Assert.assertThat((Object)sanitized, (Matcher)CoreMatchers.equalTo((Object)"<sftp:outbound-endpoint address=\"sftp://<<credentials>>@localhost:22198/~/testdir"));
    }

    @Test
    public void sanitizedPasswordAttribute() {
        this.withXmlElement(this.annotatedObject, "<sftp:config username=\"user\" password=\"pass\" />");
        String sanitized = LocationExecutionContextProvider.getSourceXML((AnnotatedObject)this.annotatedObject);
        Assert.assertThat((Object)sanitized, (Matcher)CoreMatchers.equalTo((Object)"<sftp:config username=\"user\" password=\"<<credentials>>\" />"));
    }

    @Test
    public void sanitizedPasswordAttributeWhenUsingRegExpCharactersInPassword() {
        String[] specialCharacters = new String[]{"^", ")"};
        String input = "<sftp:config username=\"user\" password=\"pass%sword\" />";
        for (String specialCharacter : specialCharacters) {
            this.withXmlElement(this.annotatedObject, String.format(input, specialCharacter));
            String sanitized = LocationExecutionContextProvider.getSourceXML((AnnotatedObject)this.annotatedObject);
            Assert.assertThat((Object)sanitized, (Matcher)CoreMatchers.equalTo((Object)"<sftp:config username=\"user\" password=\"<<credentials>>\" />"));
        }
    }

    @Test
    public void dwNonLiteralPasswordMasked() {
        String xmlDWGeneratedPassword = "<http:body ><![CDATA[#[\"grant_type=password&client_id=mt2-web-ui&username=\" ++ dw::core::URL::encodeURIComponent(vars.keycloakUsername!) ++ \"&password=\" ++ dw::core::URL::encodeURIComponent(vars.keycloakPassword!)]]]>\\</http:body>\n<http:headers><![CDATA[#[output application/java --- {\"Accept\" : \"application/json\",\"Content-Type\" : \"application/x-www-form-urlencoded\"]]>\\</http:headers>";
        this.withXmlElement(this.annotatedObject, xmlDWGeneratedPassword);
        String sanitized = LocationExecutionContextProvider.getSourceXML((AnnotatedObject)this.annotatedObject);
        Assert.assertThat((Object)sanitized, (Matcher)CoreMatchers.equalTo((Object)xmlDWGeneratedPassword));
    }

    private void withXmlElement(AnnotatedObject annotatedObject, String value) {
        Mockito.when((Object)annotatedObject.getAnnotation(LocationExecutionContextProvider.SOURCE_ELEMENT_ANNOTATION_KEY)).thenReturn((Object)value);
    }
}

