/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.source.MessageSource;
import org.mule.api.source.NonBlockingMessageSource;
import org.mule.construct.Flow;
import org.mule.exception.RollbackMessagingExceptionStrategy;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.processor.strategy.NonBlockingProcessingStrategy;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class FlowValidationTestCase
extends AbstractMuleTestCase {
    public static final String FLOW_NAME = "flowName";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    public MuleContext mockMuleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    public InboundEndpoint inboundEndpoint;
    @Mock
    public RollbackMessagingExceptionStrategy rollbackMessagingExceptionStrategy;
    @Mock
    public AbstractRedeliveryPolicy mockRedeliveryPolicy;
    private Flow flow;

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockMuleContext.getConfiguration().getDefaultProcessingStrategy()).thenReturn(null);
        this.flow = new Flow(FLOW_NAME, this.mockMuleContext);
    }

    @Test(expected=FlowConstructInvalidException.class)
    public void testProcessingStrategyCantBeAsyncWithRedelivery() throws Exception {
        this.configureFlowForRedelivery();
        this.flow.setProcessingStrategy((ProcessingStrategy)new AsynchronousProcessingStrategy());
        this.flow.validateConstruct();
    }

    @Test
    public void testProcessingStrategyNonBlockingSupported() throws Exception {
        this.flow.setProcessingStrategy((ProcessingStrategy)new NonBlockingProcessingStrategy());
        this.flow.setMessageSource((MessageSource)new NonBlockingMessageSource(){

            public void setListener(MessageProcessor listener) {
            }
        });
        this.flow.validateConstruct();
    }

    @Test(expected=FlowConstructInvalidException.class)
    public void testProcessingStrategyNonBlockingNotSupported() throws Exception {
        this.flow.setProcessingStrategy((ProcessingStrategy)new NonBlockingProcessingStrategy());
        this.flow.setMessageSource(new MessageSource(){

            public void setListener(MessageProcessor listener) {
            }
        });
        this.flow.validateConstruct();
    }

    @Test
    public void testChangeDefaultProcessingStrategyWithRedelivery() throws Exception {
        this.configureFlowForRedelivery();
        this.flow.validateConstruct();
        Assert.assertThat((Object)this.flow.getProcessingStrategy(), (Matcher)IsInstanceOf.instanceOf(SynchronousProcessingStrategy.class));
    }

    private void configureFlowForRedelivery() {
        Mockito.when((Object)this.inboundEndpoint.getTransactionConfig().isConfigured()).thenReturn((Object)false);
        Mockito.when((Object)this.inboundEndpoint.getExchangePattern().hasResponse()).thenReturn((Object)false);
        this.flow.setExceptionListener((MessagingExceptionHandler)this.rollbackMessagingExceptionStrategy);
        Mockito.when((Object)this.rollbackMessagingExceptionStrategy.hasMaxRedeliveryAttempts()).thenReturn((Object)true);
        Mockito.when((Object)this.rollbackMessagingExceptionStrategy.acceptsAll()).thenReturn((Object)true);
        Mockito.when((Object)this.inboundEndpoint.getRedeliveryPolicy()).thenReturn((Object)this.mockRedeliveryPolicy);
        this.flow.setMessageSource((MessageSource)this.inboundEndpoint);
    }
}

