/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.functors.NOPClosure;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.MessageExchangePattern;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.SecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.MessageDispatcher;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.endpoint.DynamicURIBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.security.TestSecurityFilter;
import org.mule.tck.testmodels.mule.TestMessageDispatcher;
import org.mule.tck.testmodels.mule.TestMessageDispatcherFactory;
import org.mule.transformer.simple.OutboundAppendTransformer;
import org.mule.transformer.simple.ResponseAppendTransformer;
import org.mule.transport.service.DefaultTransportServiceDescriptor;

public class DynamicOutboundEndpointTestCase
extends AbstractMessageProcessorTestCase {
    private MuleEvent testOutboundEvent;

    @Before
    public void setCurrentTestInstance() throws ServiceException {
        this.overrideDispatcherInServiceDescriptor();
        MyMessageDispatcherFactory.dispatcher = null;
    }

    @Before
    public void clearAssertionClosures() {
        MyMessageDispatcherFactory.afterSend = NOPClosure.getInstance();
        MyMessageDispatcherFactory.afterDispatch = NOPClosure.getInstance();
    }

    @Test
    public void testDefaultFlowRequestResponse() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertEventSent();
        Assert.assertThat((Object)responseMessage, (Matcher)Matchers.sameInstance((Object)result.getMessage()));
        this.assertEqualMessages(responseMessage, result.getMessage());
    }

    @Test
    public void testDefaultFlowOneWay() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        Assert.assertThat((Object)endpoint, (Matcher)Matchers.instanceOf(DynamicOutboundEndpoint.class));
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertEventDispatched();
        Assert.assertThat((Object)VoidMuleEvent.getInstance(), (Matcher)Matchers.sameInstance((Object)result));
        this.assertMessageSentEqual(MyMessageDispatcherFactory.dispatcher.sensedDispatchEvent);
    }

    @Test
    public void testSecurityFilterAccept() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(true), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertEventSent();
        this.assertMessageSentEqual(MyMessageDispatcherFactory.dispatcher.sensedSendEvent);
        Assert.assertThat((Object)responseMessage, (Matcher)Matchers.sameInstance((Object)result.getMessage()));
        this.assertEqualMessages(responseMessage, result.getMessage());
    }

    @Test
    public void testSecurityFilterNotAccept() throws Exception {
        AbstractMessageProcessorTestCase.TestSecurityNotificationListener securityNotificationListener = new AbstractMessageProcessorTestCase.TestSecurityNotificationListener();
        muleContext.registerListener((ServerNotificationListener)securityNotificationListener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(false), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        try {
            endpoint.process(this.testOutboundEvent);
            Assert.fail((String)"Exception expected");
        }
        catch (TestSecurityFilter.StaticMessageUnauthorisedException e) {
            this.testOutboundEvent.getFlowConstruct().getExceptionListener().handleException((Exception)((Object)e), this.testOutboundEvent);
        }
        Assert.assertThat((Object)((Object)MyMessageDispatcherFactory.dispatcher), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)securityNotificationListener.latch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)401, (Matcher)Matchers.equalTo((Object)securityNotificationListener.securityNotification.getAction()));
        Assert.assertThat((Object)securityNotificationListener.securityNotification.getResourceIdentifier(), (Matcher)Matchers.equalTo((Object)TestSecurityFilter.StaticMessageUnauthorisedException.class.getName()));
    }

    @Test
    public void testSendNotification() throws Exception {
        final AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener(2);
        muleContext.registerListener((ServerNotificationListener)listener);
        final MuleEvent outboundEvent = this.createTestOutboundEvent();
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        MyMessageDispatcherFactory.afterSend = new Closure(){

            public void execute(Object input) {
                try {
                    Assert.assertThat((Object)listener.latchFirst.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)Boolean.TRUE));
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
                Assert.assertThat(listener.messageNotificationList, (Matcher)IsCollectionWithSize.hasSize((int)1));
                Assert.assertThat((Object)listener.messageNotificationList.get(0).getAction(), (Matcher)Matchers.is((Object)803));
                Assert.assertThat((Object)listener.messageNotificationList.get(0).getSource(), (Matcher)Matchers.instanceOf(MuleMessage.class));
                Assert.assertThat((Object)listener.messageNotificationList.get(0).getSource().getPayload(), (Matcher)Matchers.is((Object)outboundEvent.getMessage().getPayload()));
            }
        };
        endpoint.process(outboundEvent);
        this.assertEventSent();
        Assert.assertThat((Object)listener.latch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)Boolean.TRUE));
        Assert.assertThat(listener.messageNotificationList, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)listener.messageNotificationList.get(0).getAction(), (Matcher)Matchers.is((Object)803));
        Assert.assertThat((Object)listener.messageNotificationList.get(1).getAction(), (Matcher)Matchers.is((Object)852));
        Assert.assertThat((Object)listener.messageNotificationList.get(0).getSource(), (Matcher)Matchers.instanceOf(MuleMessage.class));
        Assert.assertThat((Object)listener.messageNotificationList.get(1).getSource(), (Matcher)Matchers.instanceOf(MuleMessage.class));
        Assert.assertThat((Object)listener.messageNotificationList.get(0).getSource().getPayload(), (Matcher)Matchers.is((Object)outboundEvent.getMessage().getPayload()));
        Assert.assertThat((Object)listener.messageNotificationList.get(1).getSource().getPayload(), (Matcher)Matchers.is((Object)RESPONSE_MESSAGE));
    }

    @Test
    public void testDispatchNotification() throws Exception {
        final AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener(2);
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        final MuleEvent outboundEvent = this.createTestOutboundEvent();
        MyMessageDispatcherFactory.afterDispatch = new Closure(){

            public void execute(Object input) {
                try {
                    Assert.assertThat((Object)listener.latchFirst.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)Boolean.TRUE));
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
                Assert.assertThat(listener.messageNotificationList, (Matcher)IsCollectionWithSize.hasSize((int)1));
                Assert.assertThat((Object)listener.messageNotificationList.get(0).getAction(), (Matcher)Matchers.is((Object)802));
                Assert.assertThat((Object)listener.messageNotificationList.get(0).getSource(), (Matcher)Matchers.instanceOf(MuleMessage.class));
                Assert.assertThat((Object)listener.messageNotificationList.get(0).getSource().getPayload(), (Matcher)Matchers.is((Object)outboundEvent.getMessage().getPayload()));
            }
        };
        endpoint.process(outboundEvent);
        this.assertEventDispatched();
        Assert.assertThat((Object)listener.latch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)Boolean.TRUE));
        Assert.assertThat(listener.messageNotificationList, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)listener.messageNotificationList.get(0).getAction(), (Matcher)Matchers.is((Object)802));
        Assert.assertThat((Object)listener.messageNotificationList.get(1).getAction(), (Matcher)Matchers.is((Object)851));
        Assert.assertThat((Object)listener.messageNotificationList.get(0).getSource(), (Matcher)Matchers.instanceOf(MuleMessage.class));
        Assert.assertThat((Object)listener.messageNotificationList.get(1).getSource(), (Matcher)Matchers.instanceOf(MuleMessage.class));
        Assert.assertThat((Object)listener.messageNotificationList.get(0).getSource().getPayload(), (Matcher)Matchers.is((Object)outboundEvent.getMessage().getPayload()));
        Assert.assertThat((Object)listener.messageNotificationList.get(1).getSource().getPayload(), (Matcher)Matchers.is((Object)outboundEvent.getMessage().getPayload()));
    }

    @Test
    public void testTransformers() throws Exception {
        OutboundAppendTransformer dynamicTransformer = new OutboundAppendTransformer();
        ResponseAppendTransformer dynamicResponseTransformer = new ResponseAppendTransformer();
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, (Transformer)dynamicTransformer, (Transformer)dynamicResponseTransformer, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleRegistry spiedRegistry = (MuleRegistry)Mockito.spy((Object)muleContext.getRegistry());
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Assert.assertThat((Object)("Test Message" + OutboundAppendTransformer.APPEND_STRING), (Matcher)Matchers.equalTo((Object)MyMessageDispatcherFactory.dispatcher.sensedSendEvent.getMessageAsString()));
        Assert.assertThat((Object)(RESPONSE_MESSAGE + ResponseAppendTransformer.APPEND_STRING), (Matcher)Matchers.equalTo((Object)result.getMessageAsString()));
        Assert.assertThat(muleContext.getRegistry().lookupByType(OutboundAppendTransformer.class).keySet(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat(muleContext.getRegistry().lookupByType(ResponseAppendTransformer.class).keySet(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testConnectorNotAvailableOnDynamicEndpoint() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        endpoint.getConnector();
    }

    @Test
    public void testTimeoutSetOnEvent() throws Exception {
        int testTimeout = 999;
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        this.testOutboundEvent.getMessage().setOutboundProperty("MULE_EVENT_TIMEOUT", (Object)testTimeout);
        MuleEvent response = endpoint.process(this.testOutboundEvent);
        Assert.assertThat((Object)testTimeout, (Matcher)Matchers.equalTo((Object)response.getTimeout()));
    }

    @Test
    public void cachesResolvedStaticEndpoints() throws Exception {
        OutboundEndpoint prototypeEndpoint = (OutboundEndpoint)Mockito.mock(OutboundEndpoint.class);
        Mockito.when((Object)prototypeEndpoint.getMuleContext()).thenReturn((Object)muleContext);
        EndpointBuilder staticEndpointBuilder = (EndpointBuilder)Mockito.mock(EndpointBuilder.class);
        Mockito.when((Object)staticEndpointBuilder.buildOutboundEndpoint()).thenReturn((Object)prototypeEndpoint);
        EndpointBuilder endpointBuilder = (EndpointBuilder)Mockito.mock(EndpointBuilder.class);
        Mockito.when((Object)endpointBuilder.buildOutboundEndpoint()).thenReturn((Object)prototypeEndpoint);
        Mockito.when((Object)endpointBuilder.clone()).thenReturn((Object)staticEndpointBuilder);
        DynamicOutboundEndpoint dynamicOutboundEndpoint = new DynamicOutboundEndpoint(endpointBuilder, new DynamicURIBuilder(new URIBuilder("test://localhost:#[header:port]", muleContext)));
        this.testOutboundEvent = this.createTestOutboundEvent();
        dynamicOutboundEndpoint.process(this.testOutboundEvent);
        dynamicOutboundEndpoint.process(this.testOutboundEvent);
        ((EndpointBuilder)Mockito.verify((Object)endpointBuilder, (VerificationMode)Mockito.times((int)1))).clone();
    }

    protected void assertMessageSentEqual(MuleEvent event) throws MuleException {
        Assert.assertThat((Object)"Test Message", (Matcher)Matchers.equalTo((Object)event.getMessageAsString()));
        Assert.assertThat((Object)"value1", (Matcher)Matchers.equalTo((Object)event.getMessage().getOutboundProperty("prop1")));
    }

    protected void assertEqualMessages(MuleMessage expect, MuleMessage actual) {
        Assert.assertThat((Object)expect.getPayload(), (Matcher)Matchers.equalTo((Object)actual.getPayload()));
        Assert.assertThat((Object)expect.getEncoding(), (Matcher)Matchers.equalTo((Object)actual.getEncoding()));
        Assert.assertThat((Object)expect.getUniqueId(), (Matcher)Matchers.equalTo((Object)actual.getUniqueId()));
        Assert.assertThat((Object)expect.getExceptionPayload(), (Matcher)Matchers.equalTo((Object)actual.getExceptionPayload()));
    }

    private void assertEventDispatched() {
        PollingProber prober = new PollingProber();
        prober.check(new Probe(){

            @Override
            public boolean isSatisfied() {
                return MyMessageDispatcherFactory.dispatcher != null && MyMessageDispatcherFactory.dispatcher.dispatchedEvent;
            }

            @Override
            public String describeFailure() {
                return "Expected dispatcher was not called";
            }
        });
        Assert.assertThat((Object)MyMessageDispatcherFactory.dispatcher.sensedSendEvent, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)MyMessageDispatcherFactory.dispatcher.sensedDispatchEvent, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Assert.assertThat((Object)MyMessageDispatcherFactory.dispatcher.sensedDispatchEvent.getMessage(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    private void assertEventSent() {
        PollingProber prober = new PollingProber();
        prober.check(new Probe(){

            @Override
            public boolean isSatisfied() {
                return MyMessageDispatcherFactory.dispatcher != null && MyMessageDispatcherFactory.dispatcher.sentEvent;
            }

            @Override
            public String describeFailure() {
                return "Expected dispatcher was not called";
            }
        });
        Assert.assertThat((Object)MyMessageDispatcherFactory.dispatcher.sensedDispatchEvent, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)MyMessageDispatcherFactory.dispatcher.sensedSendEvent, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Assert.assertThat((Object)MyMessageDispatcherFactory.dispatcher.sensedSendEvent.getMessage(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    private void overrideDispatcherInServiceDescriptor() throws ServiceException {
        Properties props = new Properties();
        props.put("dispatcher.factory", MyMessageDispatcherFactory.class.getName());
        DefaultTransportServiceDescriptor serviceDescriptor = (DefaultTransportServiceDescriptor)muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, "test", null);
        props.put("inbound.exchange.patterns", "ONE_WAY, REQUEST_RESPONSE");
        props.put("outbound.exchange.patterns", "ONE_WAY, REQUEST_RESPONSE");
        serviceDescriptor.setOverrides(props);
    }

    protected OutboundEndpoint createOutboundEndpoint(Filter filter, SecurityFilter securityFilter, Transformer in, Transformer response, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws Exception {
        return this.createTestOutboundEndpoint("test://localhost:#[header:port]", filter, securityFilter, in, response, exchangePattern, txConfig);
    }

    public static class MyMessageDispatcherFactory
    extends TestMessageDispatcherFactory {
        static FakeMessageDispatcher dispatcher;
        static Closure afterSend;
        static Closure afterDispatch;

        @Override
        public synchronized MessageDispatcher create(OutboundEndpoint ep) throws MuleException {
            if (dispatcher != null) {
                throw new IllegalStateException("Dispatcher for this test was already created");
            }
            dispatcher = new FakeMessageDispatcher(ep, afterSend, afterDispatch);
            return dispatcher;
        }
    }

    private static class FakeMessageDispatcher
    extends TestMessageDispatcher {
        private final Closure afterSend;
        private final Closure afterDispatch;
        private MuleEvent sensedSendEvent;
        private MuleEvent sensedDispatchEvent;
        private boolean sentEvent;
        private boolean dispatchedEvent;

        public FakeMessageDispatcher(OutboundEndpoint endpoint, Closure afterSend, Closure afterDispatch) {
            super(endpoint);
            this.afterSend = afterSend;
            this.afterDispatch = afterDispatch;
        }

        @Override
        protected MuleMessage doSend(MuleEvent event) throws Exception {
            this.sensedSendEvent = event;
            this.sentEvent = true;
            this.afterSend.execute((Object)event);
            return responseMessage;
        }

        @Override
        protected void doDispatch(MuleEvent event) throws Exception {
            this.sensedDispatchEvent = event;
            this.dispatchedEvent = true;
            this.afterDispatch.execute((Object)event);
        }
    }
}

