/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.management.stats.ComponentStatistics;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class ComponentStatisticsTestCase
extends AbstractMuleTestCase {
    @Rule
    public SystemProperty statIntervalTime = new SystemProperty("statIntervalTime", null);

    private static void assertValues(ComponentStatistics stats, long numEvents, long totalTime, long avgTime, long maxTime, long minTime) {
        MatcherAssert.assertThat((String)"getExecutedEvents", (Object)stats.getExecutedEvents(), (Matcher)Matchers.equalTo((Object)numEvents));
        MatcherAssert.assertThat((String)"getTotalExecutionTime", (Object)stats.getTotalExecutionTime(), (Matcher)Matchers.equalTo((Object)totalTime));
        MatcherAssert.assertThat((String)"getAverageExecutionTime", (Object)stats.getAverageExecutionTime(), (Matcher)Matchers.equalTo((Object)avgTime));
        MatcherAssert.assertThat((String)"getMaxExecutionTime", (Object)stats.getMaxExecutionTime(), (Matcher)Matchers.equalTo((Object)maxTime));
        MatcherAssert.assertThat((String)"getMinExecutionTime", (Object)stats.getMinExecutionTime(), (Matcher)Matchers.equalTo((Object)minTime));
    }

    @Test
    public void verifyStatDefaults() {
        ComponentStatistics stats = new ComponentStatistics();
        ComponentStatisticsTestCase.assertValues(stats, 0L, 0L, 0L, 0L, 0L);
        MatcherAssert.assertThat((Object)stats.isEnabled(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void processSingleEvent() {
        ComponentStatistics stats = new ComponentStatistics();
        stats.addExecutionTime(100L);
        ComponentStatisticsTestCase.assertValues(stats, 1L, 100L, 100L, 100L, 100L);
    }

    @Test
    public void processSingleBranchEvent() {
        ComponentStatistics stats = new ComponentStatistics();
        stats.addExecutionBranchTime(true, 25L, 25L);
        ComponentStatisticsTestCase.assertValues(stats, 1L, 25L, 25L, 25L, 25L);
        stats.addExecutionBranchTime(false, 25L, 50L);
        ComponentStatisticsTestCase.assertValues(stats, 1L, 50L, 50L, 50L, 25L);
        stats.addCompleteExecutionTime(50L);
        ComponentStatisticsTestCase.assertValues(stats, 1L, 50L, 50L, 50L, 25L);
    }

    @Test
    public void clearStats() {
        ComponentStatistics stats = new ComponentStatistics();
        stats.addExecutionTime(100L);
        stats.clear();
        ComponentStatisticsTestCase.assertValues(stats, 0L, 0L, 0L, 0L, 0L);
    }

    @Test
    public void clearDuringBranch() {
        ComponentStatistics stats = new ComponentStatistics();
        stats.addExecutionBranchTime(true, 25L, 25L);
        stats.clear();
        ComponentStatisticsTestCase.assertValues(stats, 0L, 0L, 0L, 0L, 0L);
        stats.addExecutionBranchTime(false, 25L, 50L);
        ComponentStatisticsTestCase.assertValues(stats, 0L, 0L, 0L, 0L, 0L);
    }

    @Test
    public void verifyMaxMinAverage() {
        ComponentStatistics stats = new ComponentStatistics();
        stats.addExecutionTime(2L);
        stats.addExecutionTime(3L);
        ComponentStatisticsTestCase.assertValues(stats, 2L, 5L, 2L, 3L, 2L);
    }

    @Test
    public void verifyBranchMaxMinAverage() {
        ComponentStatistics stats = new ComponentStatistics();
        stats.addExecutionBranchTime(true, 2L, 2L);
        stats.addCompleteExecutionTime(2L);
        stats.addExecutionBranchTime(true, 3L, 3L);
        stats.addCompleteExecutionTime(3L);
        ComponentStatisticsTestCase.assertValues(stats, 2L, 5L, 2L, 3L, 2L);
    }

    @Test
    public void verifyMultiBranchMaxMinAverage() {
        ComponentStatistics stats = new ComponentStatistics();
        stats.addExecutionBranchTime(true, 1L, 1L);
        stats.addExecutionBranchTime(false, 1L, 2L);
        stats.addCompleteExecutionTime(2L);
        stats.addExecutionBranchTime(true, 3L, 3L);
        stats.addCompleteExecutionTime(3L);
        ComponentStatisticsTestCase.assertValues(stats, 2L, 5L, 2L, 3L, 1L);
    }

    @Test
    public void verifyShortStatIntervalReset() {
        System.setProperty("statIntervalTime", "-1");
        ComponentStatistics stats = new ComponentStatistics();
        stats.addExecutionTime(100L);
        ComponentStatisticsTestCase.assertValues(stats, 1L, 100L, 100L, 100L, 100L);
        stats.addExecutionTime(200L);
        ComponentStatisticsTestCase.assertValues(stats, 1L, 200L, 200L, 200L, 200L);
        stats.addExecutionBranchTime(true, 100L, 100L);
        ComponentStatisticsTestCase.assertValues(stats, 1L, 100L, 100L, 100L, 100L);
        stats.addExecutionBranchTime(true, 200L, 200L);
        ComponentStatisticsTestCase.assertValues(stats, 1L, 200L, 200L, 200L, 200L);
        stats.addCompleteExecutionTime(200L);
        ComponentStatisticsTestCase.assertValues(stats, 1L, 200L, 200L, 200L, 200L);
    }

    @Test
    public void verifyLongStatIntervalNoReset() {
        System.setProperty("statIntervalTime", "9999");
        ComponentStatistics stats = new ComponentStatistics();
        stats.addExecutionTime(100L);
        ComponentStatisticsTestCase.assertValues(stats, 1L, 100L, 100L, 100L, 100L);
        stats.addExecutionBranchTime(true, 100L, 100L);
        ComponentStatisticsTestCase.assertValues(stats, 2L, 200L, 100L, 100L, 100L);
    }
}

