/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.store.ObjectStoreException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;
import org.mule.util.store.PartitionedInMemoryObjectStore;

@SmallTest
public class PartitionedInMemoryObjectStoreTestCase
extends AbstractMuleTestCase {
    private static final String TEST_PARTITION = "testPartition";
    private static final String TEST_VALUE = "testValue";
    private static final String TEST_KEY1 = "testKey1";
    private static final String TEST_KEY2 = "testKey2";
    private static final String TEST_KEY3 = "testKey3";
    private static final int GC_TIMEOUT_MILLIS = 10000;
    private PartitionedInMemoryObjectStore<String> store;
    private long currentNanoTime = TimeUnit.MILLISECONDS.toNanos(1L);

    @Before
    public void setup() {
        this.store = new PartitionedInMemoryObjectStore(){

            protected long getCurrentNanoTime() {
                return PartitionedInMemoryObjectStoreTestCase.this.currentNanoTime;
            }
        };
    }

    @Test
    public void expireByTtlMultipleKeysInsertedInTheSameNanoSecond() throws ObjectStoreException {
        this.store.store((Serializable)((Object)TEST_KEY1), (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.store((Serializable)((Object)TEST_KEY2), (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.currentNanoTime = TimeUnit.MILLISECONDS.toNanos(2L);
        this.store.store((Serializable)((Object)TEST_KEY3), (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.expire(1, 100, TEST_PARTITION);
        Assert.assertThat((Object)this.store.contains((Serializable)((Object)TEST_KEY1), TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.store.contains((Serializable)((Object)TEST_KEY2), TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.store.retrieve((Serializable)((Object)TEST_KEY3), TEST_PARTITION), (Matcher)CoreMatchers.equalTo((Object)TEST_VALUE));
    }

    @Test
    public void expireByNumberOfEntriesMultipleKeysInsertedInTheSameNanoSecond() throws ObjectStoreException {
        this.store.store((Serializable)((Object)TEST_KEY1), (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.store((Serializable)((Object)TEST_KEY2), (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.currentNanoTime = TimeUnit.MILLISECONDS.toNanos(2L);
        this.store.store((Serializable)((Object)TEST_KEY3), (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.expire(10, 1, TEST_PARTITION);
        Assert.assertThat((Object)this.store.contains((Serializable)((Object)TEST_KEY1), TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.store.contains((Serializable)((Object)TEST_KEY2), TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.store.retrieve((Serializable)((Object)TEST_KEY3), TEST_PARTITION), (Matcher)CoreMatchers.equalTo((Object)TEST_VALUE));
    }

    @Test
    public void removeKeyInsertedInTheSameNanosecondThanOther() throws ObjectStoreException {
        this.store.store((Serializable)((Object)TEST_KEY1), (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.store((Serializable)((Object)TEST_KEY2), (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.currentNanoTime = TimeUnit.MILLISECONDS.toNanos(2L);
        this.store.store((Serializable)((Object)TEST_KEY3), (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        this.store.remove((Serializable)((Object)TEST_KEY2), TEST_PARTITION);
        Assert.assertThat((Object)this.store.retrieve((Serializable)((Object)TEST_KEY1), TEST_PARTITION), (Matcher)CoreMatchers.equalTo((Object)TEST_VALUE));
        Assert.assertThat((Object)this.store.contains((Serializable)((Object)TEST_KEY2), TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.store.retrieve((Serializable)((Object)TEST_KEY3), TEST_PARTITION), (Matcher)CoreMatchers.equalTo((Object)TEST_VALUE));
    }

    @Test
    public void removesDataOnClear() throws ObjectStoreException {
        TrackedKey trackedKey = new TrackedKey();
        PhantomReference<TrackedKey> keyRef = this.trackAndStore(trackedKey);
        this.store.clear(TEST_PARTITION);
        Assert.assertThat((Object)this.store.contains((Serializable)trackedKey, TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        trackedKey = null;
        this.validateClear(keyRef);
    }

    @Test
    public void removesDataOnClose() throws ObjectStoreException {
        TrackedKey trackedKey = new TrackedKey();
        PhantomReference<TrackedKey> keyRef = this.trackAndStore(trackedKey);
        this.store.close(TEST_PARTITION);
        Assert.assertThat((Object)this.store.contains((Serializable)trackedKey, TEST_PARTITION), (Matcher)CoreMatchers.is((Object)false));
        trackedKey = null;
        this.validateClear(keyRef);
    }

    private PhantomReference<TrackedKey> trackAndStore(TrackedKey trackedKey) throws ObjectStoreException {
        PhantomReference<TrackedKey> keyRef = new PhantomReference<TrackedKey>(trackedKey, new ReferenceQueue());
        this.store.store((Serializable)trackedKey, (Serializable)((Object)TEST_VALUE), TEST_PARTITION);
        Assert.assertThat((Object)this.store.contains((Serializable)trackedKey, TEST_PARTITION), (Matcher)CoreMatchers.is((Object)true));
        return keyRef;
    }

    private void validateClear(final PhantomReference<TrackedKey> keyRef) throws ObjectStoreException {
        new PollingProber(10000L, 100L).check(new Probe(){

            @Override
            public boolean isSatisfied() {
                System.gc();
                return keyRef.isEnqueued();
            }

            @Override
            public String describeFailure() {
                return "A hard reference is being maintained to the entry expiration info.";
            }
        });
    }

    private class TrackedKey
    implements Serializable {
        private TrackedKey() {
        }
    }
}

