/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mule.api.MuleContext;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionRollbackException;
import org.mule.transport.jdbc.i18n.JdbcMessages;

public class JdbcTransaction
extends AbstractSingleResourceTransaction {
    public JdbcTransaction(MuleContext muleContext) {
        super(muleContext);
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(key instanceof DataSource) || !(resource instanceof Connection)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCanOnlyBindToResources((String)"javax.sql.DataSource/java.sql.Connection"));
        }
        Connection con = (Connection)resource;
        try {
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new TransactionException(JdbcMessages.transactionSetAutoCommitFailed(), (Throwable)e);
        }
        super.bindResource(key, resource);
    }

    protected void doBegin() throws TransactionException {
    }

    protected void doCommit() throws TransactionException {
        if (this.resource == null) {
            this.logger.warn((Object)CoreMessages.commitTxButNoResource((Transaction)this));
            return;
        }
        TransactionException transactionException = null;
        try {
            ((Connection)this.resource).commit();
        }
        catch (SQLException e) {
            try {
                transactionException = new TransactionException(CoreMessages.transactionCommitFailed(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeConnection(transactionException);
                throw throwable;
            }
            this.closeConnection(transactionException);
        }
        this.closeConnection(transactionException);
    }

    private void closeConnection(TransactionException transactionException) throws TransactionException {
        try {
            ((Connection)this.resource).close();
        }
        catch (SQLException e) {
            if (transactionException == null) {
                transactionException = new TransactionException(CoreMessages.createStaticMessage((String)"Cannot close connection."), (Throwable)e);
            }
            this.logger.info((Object)"Cannot close connection.");
        }
        if (transactionException != null) {
            throw transactionException;
        }
    }

    protected void doRollback() throws TransactionException {
        if (this.resource == null) {
            this.logger.warn((Object)CoreMessages.rollbackTxButNoResource((Transaction)this));
            return;
        }
        TransactionRollbackException transactionException = null;
        try {
            ((Connection)this.resource).rollback();
        }
        catch (SQLException e) {
            try {
                transactionException = new TransactionRollbackException(CoreMessages.transactionRollbackFailed(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeConnection((TransactionException)transactionException);
                throw throwable;
            }
            this.closeConnection((TransactionException)transactionException);
        }
        this.closeConnection((TransactionException)transactionException);
    }

    protected Class<Connection> getResourceType() {
        return Connection.class;
    }

    protected Class<DataSource> getKeyType() {
        return DataSource.class;
    }
}

