/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.database;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.module.db.internal.domain.connection.DbPoolingProfile;
import org.mule.util.StringUtils;

public class DataSourceConfig
implements MuleContextAware {
    public static final int NO_TRANSACTION_ISOLATION_CONFIGURED = -1;
    private MuleContext muleContext;
    private String url;
    private String driverClassName;
    private int connectionTimeout;
    private String password;
    private String user;
    private int transactionIsolation = -1;
    private boolean useXaTransactions;
    private DbPoolingProfile poolingProfile;

    public DataSourceConfig resolve(MuleEvent muleEvent) {
        if (muleEvent == null) {
            return this;
        }
        DataSourceConfig resolved = new DataSourceConfig();
        resolved.setMuleContext(this.muleContext);
        resolved.url = this.resolveAttribute(this.url, muleEvent);
        resolved.driverClassName = this.resolveAttribute(this.driverClassName, muleEvent);
        resolved.password = this.resolveAttribute(this.password, muleEvent);
        resolved.user = this.resolveAttribute(this.user, muleEvent);
        resolved.connectionTimeout = this.connectionTimeout;
        resolved.transactionIsolation = this.transactionIsolation;
        resolved.useXaTransactions = this.useXaTransactions;
        resolved.poolingProfile = this.poolingProfile;
        return resolved;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public boolean isUseXaTransactions() {
        return this.useXaTransactions;
    }

    public void setUseXaTransactions(boolean useXaTransactions) {
        this.useXaTransactions = useXaTransactions;
    }

    public DbPoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setPoolingProfile(DbPoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public boolean isDynamic() {
        return this.isDynamicAttribute(this.url) || this.isDynamicAttribute(this.user) || this.isDynamicAttribute(this.password) || this.isDynamicAttribute(this.driverClassName);
    }

    private boolean isDynamicAttribute(String attribute) {
        return !StringUtils.isEmpty((String)attribute) && this.muleContext.getExpressionManager().isExpression(attribute) && this.muleContext.getExpressionManager().isValidExpression(attribute);
    }

    private String resolveAttribute(String value, MuleEvent muleEvent) {
        return this.isDynamicAttribute(value) ? this.muleContext.getExpressionManager().parse(value, muleEvent) : value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceConfig that = (DataSourceConfig)o;
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.transactionIsolation != that.transactionIsolation) {
            return false;
        }
        if (this.useXaTransactions != that.useXaTransactions) {
            return false;
        }
        if (!this.url.equals(that.url)) {
            return false;
        }
        if (!this.driverClassName.equals(that.driverClassName)) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.poolingProfile == null ? that.poolingProfile != null : !this.poolingProfile.equals(that.poolingProfile));
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.driverClassName.hashCode();
        result = 31 * result + this.connectionTimeout;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + this.transactionIsolation;
        result = 31 * result + (this.useXaTransactions ? 1 : 0);
        result = 31 * result + (this.poolingProfile != null ? this.poolingProfile.hashCode() : 0);
        return result;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

