/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.posix.util.Platform;
import org.python.core.Options;
import org.python.core.Py;

public class PrePy {
    protected static final Logger logger = Logger.getLogger("org.python");
    protected static final Logger importLogger = Logger.getLogger("org.python.import");
    public static final int ERROR = -1;
    public static final int WARNING = 0;
    public static final int MESSAGE = 1;
    public static final int COMMENT = 2;
    public static final int DEBUG = 3;
    static final Level[] LEVELS = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
    private static int savedVerbosity = 1;

    public static Level levelFromVerbosity(int verbosity) {
        if (verbosity < -1) {
            return Level.OFF;
        }
        if (verbosity >= LEVELS.length + -2) {
            return Level.ALL;
        }
        int index = verbosity - -2;
        return LEVELS[index];
    }

    public static int verbosityFromLevel(Level level) {
        int intLevel = level.intValue();
        int index = 0;
        int v = -2;
        while (index < LEVELS.length && LEVELS[index].intValue() > intLevel) {
            assert (LEVELS[index] == PrePy.levelFromVerbosity(v));
            ++index;
            ++v;
        }
        return v;
    }

    private static Level getEffectiveLoggingLevel(Logger logger) {
        Level level;
        while ((level = logger.getLevel()) == null) {
            logger = logger.getParent();
        }
        return level;
    }

    public static Level getLoggingLevel() {
        return PrePy.getEffectiveLoggingLevel(logger);
    }

    public static Level setLoggingLevel(Level newLevel) {
        Level previousLevel = PrePy.getLoggingLevel();
        if (newLevel != previousLevel) {
            try {
                logger.setLevel(newLevel);
            }
            catch (SecurityException se) {
                logger.warning("A security manager prevented a change to the logging level.");
                newLevel = previousLevel;
            }
        }
        savedVerbosity = Options.verbose = PrePy.verbosityFromLevel(newLevel);
        return previousLevel;
    }

    public static void increaseLoggingLevel(int n) {
        int v = PrePy.verbosityFromLevel(PrePy.getLoggingLevel());
        PrePy.setLoggingLevel(PrePy.levelFromVerbosity(v + n));
    }

    private static void syncLoggingLevel() {
        if (Options.verbose != savedVerbosity) {
            savedVerbosity = Options.verbose;
            Level level = PrePy.levelFromVerbosity(savedVerbosity);
            PrePy.setLoggingLevel(level);
        }
    }

    public static void maybeWrite(String type, String msg2, int verbosity) {
        PrePy.syncLoggingLevel();
        if (verbosity <= Options.verbose) {
            logger.log(PrePy.levelFromVerbosity(verbosity), "{0}: {1}", new Object[]{type, msg2});
        }
    }

    public static void writeError(String type, String msg2) {
        PrePy.maybeWrite(type, msg2, -1);
    }

    public static void writeWarning(String type, String msg2) {
        PrePy.maybeWrite(type, msg2, 0);
    }

    public static void writeMessage(String type, String msg2) {
        PrePy.maybeWrite(type, msg2, 1);
    }

    public static void writeComment(String type, String msg2) {
        PrePy.maybeWrite(type, msg2, 2);
    }

    public static void writeDebug(String type, String msg2) {
        PrePy.maybeWrite(type, msg2, 3);
    }

    public static Properties getSystemProperties() {
        try {
            return System.getProperties();
        }
        catch (AccessControlException ace) {
            return new Properties();
        }
    }

    public static String getSystemProperty(String key, String defaultValue) {
        try {
            String value = System.getProperty(key, null);
            return value != null ? value : defaultValue;
        }
        catch (AccessControlException ace) {
            return defaultValue;
        }
    }

    public static boolean isInteractive() {
        String tty2 = PrePy.getSystemProperty("python.launcher.tty", "");
        if (tty2.equalsIgnoreCase("true")) {
            return true;
        }
        if (tty2.equalsIgnoreCase("false")) {
            return false;
        }
        return PrePy.haveConsole();
    }

    public static boolean haveConsole() {
        try {
            return System.console() != null;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean isInteractive(InputStream fp, String filename) {
        if (fp == System.in && PrePy.isInteractive()) {
            return true;
        }
        if (!Options.interactive) {
            return false;
        }
        return filename == null || filename.equals("<stdin>") || filename.equals("???");
    }

    public static String getDefaultExecutableName() {
        return PrePy.getDefaultBinDir() + File.separator + (Platform.IS_WINDOWS ? "jython.exe" : "jython");
    }

    public static String getDefaultBinDir() {
        String jar = PrePy._getJarFileName();
        return jar.substring(0, jar.lastIndexOf(File.separatorChar) + 1) + "bin";
    }

    public static String getJarFileName() {
        String jar = PrePy._getJarFileName();
        return jar;
    }

    private static String _getJarFileName() {
        Class<PrePy> thisClass = PrePy.class;
        String fullClassName = thisClass.getName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        URL url = thisClass.getResource(className + ".class");
        return PrePy.getJarFileNameFromURL(url);
    }

    public static String getJarFileNameFromURL(URL url) {
        URI fileURI = null;
        try {
            switch (url == null ? "" : url.getProtocol()) {
                case "jar": {
                    if (Platform.IS_WINDOWS) {
                        url = PrePy.tweakWindowsFileURL(url);
                    }
                    URLConnection c = url.openConnection();
                    fileURI = ((JarURLConnection)c).getJarFileURL().toURI();
                    break;
                }
                case "vfs": 
                case "vfszip": {
                    String path = url.getPath();
                    String target = ".jar/" + Py.class.getName().replace('.', '/');
                    int jarIndex = path.indexOf(target);
                    if (jarIndex <= 0) break;
                    fileURI = new URL("file:" + path.substring(0, jarIndex + 4)).toURI();
                    break;
                }
            }
        }
        catch (IOException | IllegalArgumentException | URISyntaxException exception) {
            // empty catch block
        }
        return fileURI == null ? null : new File(fileURI).toString();
    }

    private static URL tweakWindowsFileURL(URL url) throws MalformedURLException {
        String urlstr = url.toString();
        int fileIndex = urlstr.indexOf("file://");
        if (fileIndex >= 0) {
            int insert = fileIndex + 7;
            if (urlstr.length() > insert && urlstr.charAt(insert) != '/') {
                url = new URL(urlstr.substring(0, insert) + "//" + urlstr.substring(insert));
            }
        }
        return url;
    }

    public static String getCommandResult(String ... command) {
        String result2 = "";
        String line = null;
        ProcessBuilder pb = new ProcessBuilder(command);
        try {
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0 || result2.length() != 0) continue;
                result2 = line.trim();
            }
            br.close();
            if (p.waitFor() != 0) {
                result2 = "";
            }
        }
        catch (IOException | InterruptedException | SecurityException e) {
            result2 = "";
        }
        return result2;
    }
}

