/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.parser.json;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mule.common.metadata.parser.json.AbstractType;
import org.mule.common.metadata.parser.json.JSONPointerType;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.SchemaEnv;
import org.mule.common.metadata.parser.json.SchemaException;

public class JSONObjectType
extends AbstractType {
    private String id;
    private String name = null;
    private String description = null;
    private boolean isStrict = false;
    private Map<String, JSONType> properties = new TreeMap<String, JSONType>();

    public JSONObjectType(SchemaEnv env, JSONObject obj) throws SchemaException {
        try {
            Object type;
            if (env.getParent() == null) {
                env.addType("#", this);
            }
            if (!obj.has("type") && !obj.has("properties")) {
                throw new SchemaException(String.format("Missing required 'type' or 'properties' property in \n%s", obj.toString()));
            }
            if (obj.has("type") && !(type = obj.get("type")).toString().toLowerCase().equals("object")) {
                if (type instanceof JSONArray) {
                    this.properties.put("text", new JSONType.StringType());
                } else {
                    throw new SchemaException(String.format("Cannot convert expression %s into JSONObjectType", obj.toString()));
                }
            }
            if (obj.has("strict")) {
                this.isStrict = obj.getBoolean("strict");
            }
            if (obj.has("name")) {
                String name;
                this.name = name = obj.getString("name");
                env.addType(name, this);
            }
            if (obj.has("description")) {
                this.description = obj.getString("description");
            }
            if (obj.has("id")) {
                this.setId(obj.getString("id"));
                String id = this.getId().split("#")[0];
                env.addType(id, this);
            }
            if (obj.has("$ref")) {
                String reference = obj.getString("$ref");
                JSONType resolvedReference = new JSONPointerType(env, reference).resolve();
                if (resolvedReference instanceof JSONObjectType) {
                    String[] jsonObjectProperties;
                    JSONObjectType jsonObjectType = (JSONObjectType)resolvedReference;
                    for (String property : jsonObjectProperties = jsonObjectType.getProperties()) {
                        JSONType propertyType = jsonObjectType.getPropertyType(property);
                        this.properties.put(property, propertyType);
                    }
                }
            } else if (obj.has("properties")) {
                JSONObject propObj = obj.getJSONObject("properties");
                Iterator itr = propObj.keys();
                while (itr.hasNext()) {
                    String propName = (String)itr.next();
                    Object propValue = propObj.get(propName);
                    JSONType propType = env.evaluate(propValue);
                    this.properties.put(propName, propType);
                }
            }
        }
        catch (JSONException e) {
            throw new SchemaException(obj.toString(), e);
        }
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == null || !(obj instanceof JSONObject)) {
            return false;
        }
        JSONObject json = (JSONObject)obj;
        Iterator keys = json.keys();
        TreeSet<String> toSee = new TreeSet<String>(this.properties.keySet());
        TreeSet<String> seen = new TreeSet<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (seen.contains(key)) {
                return false;
            }
            if (toSee.contains(key)) {
                try {
                    if (!this.properties.get(key).contains(json.get(key))) {
                        return false;
                    }
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException(String.format("%s in %s", key, obj.toString()));
                }
                toSee.remove(key);
                seen.add(key);
                continue;
            }
            if (!this.isStrict) continue;
            return false;
        }
        for (String undefinedKey : toSee) {
            if (this.properties.get(undefinedKey).isOptional()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String explain(Object obj) {
        if (obj == null) {
            return String.format("REJECT: null value", new Object[0]);
        }
        if (!(obj instanceof JSONObject)) {
            return String.format("REJECT: value %s has type %s not in JSONObject", obj.toString(), obj.getClass().getSimpleName());
        }
        JSONObject json = (JSONObject)obj;
        Iterator keys = json.keys();
        TreeSet<String> toSee = new TreeSet<String>(this.properties.keySet());
        TreeSet<String> seen = new TreeSet<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (seen.contains(key)) {
                return String.format("REJECT: unexpected duplicate key \"%s\" in %s", key, json.toString());
            }
            if (toSee.contains(key)) {
                try {
                    if (!this.properties.get(key).contains(json.get(key))) {
                        return String.format("%s: %s", key, this.properties.get(key).explain(json.get(key)));
                    }
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException(String.format("%s in %s", key, obj.toString()));
                }
                toSee.remove(key);
                seen.add(key);
                continue;
            }
            if (!this.isStrict) continue;
            return String.format("REJECT: extra key %s in 'strict' type %s", key, this.name);
        }
        for (String undefinedKey : toSee) {
            if (this.properties.get(undefinedKey).isOptional()) continue;
            return String.format("REJECT: missing non-optional key: %s", undefinedKey);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getProperties() {
        return this.properties.keySet().toArray(new String[0]);
    }

    public JSONType getPropertyType(String propName) {
        return this.properties.get(propName);
    }

    @Override
    public boolean isJSONPrimitive() {
        return false;
    }

    @Override
    public boolean isJSONArray() {
        return false;
    }

    @Override
    public boolean isJSONObject() {
        return true;
    }

    @Override
    public boolean isJSONPointer() {
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

