/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.extension.annotations.param.Optional;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Described;
import org.mule.extension.introspection.Extension;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.ConfigurationInstanceRegistrationCallback;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.internal.runtime.ConfigurationObjectBuilder;
import org.mule.module.extension.internal.runtime.DynamicConfigurationInstanceProvider;
import org.mule.module.extension.internal.runtime.OperationContextAdapter;
import org.mule.module.extension.internal.runtime.StaticConfigurationInstanceProvider;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.util.ArrayUtils;
import org.mule.util.Preconditions;

public class MuleExtensionUtils {
    private MuleExtensionUtils() {
    }

    public static void validateRepeatedNames(Collection<? extends Described> ... describedCollections) {
        if (ArrayUtils.isEmpty((Object[])describedCollections)) {
            return;
        }
        ArrayList<? extends Described> all = new ArrayList<Described>();
        for (Collection<? extends Described> describedCollection : describedCollections) {
            all.addAll(describedCollection);
        }
        Set<String> clashes = MuleExtensionUtils.collectRepeatedNames(all);
        if (!clashes.isEmpty()) {
            throw new IllegalArgumentException("The following names have been assigned to multiple components: " + Joiner.on((String)", ").join(clashes));
        }
    }

    public static <T extends Described> Map<String, T> toMap(List<T> objects) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Described object : objects) {
            map.put((Object)object.getName(), (Object)object);
        }
        return map.build();
    }

    public static <T> boolean hasAnyDynamic(Iterable<ValueResolver<T>> resolvers) {
        for (ValueResolver<T> resolver : resolvers) {
            if (!resolver.isDynamic()) continue;
            return true;
        }
        return false;
    }

    public static <T extends Described> List<T> alphaSortDescribedList(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        Collections.sort(list, new DescribedComparator());
        return list;
    }

    public static <T> ConfigurationInstanceProvider<T> createConfigurationInstanceProvider(String name, Extension extension, Configuration configuration, ResolverSet resolverSet, MuleContext muleContext, ConfigurationInstanceRegistrationCallback registrationCallback) throws Exception {
        ConfigurationObjectBuilder configurationObjectBuilder = new ConfigurationObjectBuilder(name, extension, configuration, resolverSet, registrationCallback);
        if (resolverSet.isDynamic()) {
            return new DynamicConfigurationInstanceProvider(configurationObjectBuilder, resolverSet);
        }
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage(null, muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)null);
        return new StaticConfigurationInstanceProvider<Object>(configurationObjectBuilder.build((MuleEvent)event));
    }

    public static OperationContextAdapter asOperationContextAdapter(OperationContext operationContext) {
        Preconditions.checkArgument((operationContext != null ? 1 : 0) != 0, (String)"operationContext cannot be null");
        if (!(operationContext instanceof OperationContextAdapter)) {
            throw new IllegalArgumentException(String.format("operationContext was expected to be an instance of %s but got %s instead", OperationContextAdapter.class.getName(), operationContext.getClass().getName()));
        }
        return (OperationContextAdapter)operationContext;
    }

    public static String getDefaultValue(Optional optional) {
        if (optional == null) {
            return null;
        }
        String defaultValue = optional.defaultValue();
        return "THIS IS A SPECIAL NULL VALUE - DO NOT USE".equals(defaultValue) ? null : defaultValue;
    }

    public static MuleEvent getInitialiserEvent(MuleContext muleContext) {
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage(null, muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)null);
    }

    private static Set<String> collectRepeatedNames(Collection<? extends Described> describedCollection) {
        String name;
        if (CollectionUtils.isEmpty(describedCollection)) {
            return ImmutableSet.of();
        }
        LinkedHashMultiset names = LinkedHashMultiset.create();
        for (Described iterator : describedCollection) {
            if (iterator == null) {
                throw new IllegalArgumentException("A null described was provided");
            }
            names.add((Object)iterator.getName());
        }
        names = Multisets.copyHighestCountFirst((Multiset)names);
        HashSet<String> repeatedNames = new HashSet<String>();
        Iterator iterator = names.iterator();
        while (iterator.hasNext() && names.count((Object)(name = (String)iterator.next())) != 1) {
            repeatedNames.add(name);
        }
        return repeatedNames;
    }

    private static class DescribedComparator
    implements Comparator<Described> {
        private DescribedComparator() {
        }

        @Override
        public int compare(Described o1, Described o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

