/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.HttpCallback;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.Connector;
import org.mule.config.spring.factories.AsyncMessageProcessorsFactoryBean;
import org.mule.construct.Flow;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.listener.HttpListener;
import org.mule.module.http.api.listener.HttpListenerBuilder;
import org.mule.module.http.api.listener.HttpListenerConfig;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;

public class DefaultHttpCallback
implements HttpCallback {
    private static final Logger LOGGER = Logger.getLogger(DefaultHttpCallback.class);
    private Integer localPort;
    private Integer remotePort;
    private String domain;
    private String url;
    private String localUrl;
    private MuleContext muleContext;
    private Flow callbackFlow;
    private Flow flow;
    private MessageProcessor callbackMessageProcessor;
    private String callbackPath;
    private Boolean async;
    private Object connector;
    private ConnectorDelegate connectorDelegate;
    private boolean forceOldHttpTransport = false;
    private MessagingExceptionHandler exceptionHandler;

    public DefaultHttpCallback(Flow callbackFlow, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async) {
        this.callbackFlow = callbackFlow;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
    }

    public DefaultHttpCallback(MessageProcessor callbackMessageProcessor, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async) {
        this.callbackMessageProcessor = callbackMessageProcessor;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
    }

    public DefaultHttpCallback(MessageProcessor callbackMessageProcessor, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async) {
        this.callbackMessageProcessor = callbackMessageProcessor;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
    }

    public DefaultHttpCallback(Flow callbackFlow, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async, Object connector) {
        this.callbackFlow = callbackFlow;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
        this.connector = connector;
    }

    public DefaultHttpCallback(MessageProcessor callbackMessageProcessor, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async, Object connector) {
        this.callbackMessageProcessor = callbackMessageProcessor;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
        this.connector = connector;
    }

    public DefaultHttpCallback(MessageProcessor callbackMessageProcessor, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async, Object connector) {
        this.callbackMessageProcessor = callbackMessageProcessor;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connector = connector;
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async, Object connector) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
        this.connector = connector;
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async, Object connector) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connector = connector;
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async, MessagingExceptionHandler exceptionHandler) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connectorDelegate = null;
        this.exceptionHandler = exceptionHandler;
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async, MessagingExceptionHandler exceptionHandler, Object connector) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connectorDelegate = null;
        this.exceptionHandler = exceptionHandler;
        this.connector = connector;
    }

    public DefaultHttpCallback(MessageProcessor callbackMessageProcessor, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async, MessagingExceptionHandler exceptionHandler, Object connector) throws MuleException {
        this.callbackMessageProcessor = callbackMessageProcessor;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connectorDelegate = null;
        this.exceptionHandler = exceptionHandler;
        this.connector = connector;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    private ConnectorDelegate getConnectorDelegate(Object connector) throws MuleException {
        if (connector != null) {
            if (connector instanceof Connector) {
                return new OldTransportDelegate((Connector)connector);
            }
            if (connector instanceof HttpListenerConfig) {
                return new HttpConnectorDelegate((HttpListenerConfig)connector);
            }
            throw new IllegalArgumentException(String.format("Could not create OAuth callback at url %s because a connector of class %s was supplied. Valid types are '%s' and '%s' ", this.url, connector.getClass().getName(), HttpListenerConfig.class.getName(), Connector.class));
        }
        if (this.forceOldHttpTransport) {
            return new OldTransportDelegate(this.lookupDefaultHttpTransport());
        }
        return new HttpConnectorDelegate();
    }

    private Connector lookupDefaultHttpTransport() throws MuleException {
        Connector httpConnector = this.muleContext.getRegistry().lookupConnector("connector.http.mule.default");
        if (httpConnector != null) {
            return httpConnector;
        }
        throw new DefaultMuleException("Could not find connector with name 'connector.http.mule.default'");
    }

    private String buildUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        if (!this.domain.contains("://")) {
            if (this.connectorDelegate != null) {
                urlBuilder.append(this.connectorDelegate.getScheme() + "://");
            } else {
                urlBuilder.append("http://");
            }
        }
        urlBuilder.append(this.domain);
        if (this.remotePort != null && this.remotePort != 80) {
            urlBuilder.append(":");
            urlBuilder.append(this.remotePort);
        }
        urlBuilder.append("/");
        if (this.callbackPath != null) {
            urlBuilder.append(this.callbackPath);
        } else {
            urlBuilder.append(UUID.randomUUID());
        }
        return urlBuilder.toString();
    }

    public void setForceOldHttpTransport(boolean forceOldHttpTransport) {
        this.forceOldHttpTransport = forceOldHttpTransport;
    }

    private MessageProcessor wrapMessageProcessorInAsyncChain(MessageProcessor messageProcessor) throws MuleException {
        AsyncMessageProcessorsFactoryBean asyncMessageProcessorsFactoryBean = new AsyncMessageProcessorsFactoryBean();
        asyncMessageProcessorsFactoryBean.setMuleContext(this.muleContext);
        asyncMessageProcessorsFactoryBean.setMessageProcessors(Arrays.asList(messageProcessor));
        asyncMessageProcessorsFactoryBean.setProcessingStrategy((ProcessingStrategy)new AsynchronousProcessingStrategy());
        try {
            return (MessageProcessor)asyncMessageProcessorsFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new FlowConstructInvalidException((Throwable)e);
        }
    }

    private InboundEndpoint createHttpInboundEndpoint() throws MuleException {
        EndpointURIEndpointBuilder inBuilder = new EndpointURIEndpointBuilder(this.localUrl, this.muleContext);
        inBuilder.setConnector((Connector)this.connectorDelegate.getConnector());
        inBuilder.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
        EndpointFactory endpointFactory = this.muleContext.getEndpointFactory();
        return endpointFactory.getInboundEndpoint((EndpointBuilder)inBuilder);
    }

    public void start() throws MuleException {
        String dynamicFlowName = String.format("DynamicFlow-%s:%d/%s", this.domain, this.localPort, this.callbackPath);
        this.flow = new Flow(dynamicFlowName, this.muleContext);
        this.connectorDelegate = this.getConnectorDelegate(this.connector);
        this.url = this.buildUrl();
        this.localUrl = this.url.replaceFirst(this.domain, "localhost");
        this.localUrl = this.localUrl.indexOf(":" + String.valueOf(this.remotePort)) == -1 ? this.localUrl.replaceFirst("localhost", "localhost:" + String.valueOf(this.localPort)) : this.localUrl.replaceFirst(String.valueOf(this.remotePort), String.valueOf(this.localPort));
        MessageSource source = this.connectorDelegate.getMessageSource();
        if (source instanceof FlowConstructAware) {
            ((FlowConstructAware)source).setFlowConstruct((FlowConstruct)this.flow);
        }
        this.flow.setMessageSource(source);
        MessageProcessor messageProcessor = this.callbackFlow != null ? new FlowRefMessageProcessor() : this.callbackMessageProcessor;
        if (this.async.booleanValue()) {
            messageProcessor = this.wrapMessageProcessorInAsyncChain(messageProcessor);
        }
        ArrayList<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();
        messageProcessors.add(messageProcessor);
        this.flow.setMessageProcessors(messageProcessors);
        if (this.exceptionHandler != null) {
            this.flow.setExceptionListener(this.exceptionHandler);
        }
        this.muleContext.getRegistry().registerObject(dynamicFlowName, (Object)this.flow);
        LOGGER.debug((Object)String.format("Created flow with http inbound endpoint listening at: %s", this.url));
    }

    public void stop() throws MuleException {
        if (this.flow != null) {
            String flowName = this.flow.getName();
            this.flow.stop();
            this.flow.dispose();
            this.muleContext.getRegistry().unregisterObject(flowName);
            LOGGER.debug((Object)"Http callback flow stopped");
        }
    }

    private static MessageProcessor buildChain(List<MessageProcessor> messageProcessors) throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        for (MessageProcessor messageProcessor : messageProcessors) {
            if (messageProcessor instanceof MessageProcessor) {
                builder.chain(new MessageProcessor[]{messageProcessor});
                continue;
            }
            if (!(messageProcessor instanceof MessageProcessorBuilder)) continue;
            builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)messageProcessor});
        }
        return builder.build();
    }

    public Flow getFlow() {
        return this.flow;
    }

    private class HttpConnectorDelegate
    implements ConnectorDelegate<HttpListenerConfig> {
        private final HttpListenerConfig listenerConfig;
        private final HttpListener messageSource;

        private HttpConnectorDelegate(HttpListenerConfig listenerConfig) throws MuleException {
            this.listenerConfig = listenerConfig;
            this.messageSource = new HttpListenerBuilder(DefaultHttpCallback.this.muleContext).setListenerConfig(listenerConfig).setPath(this.sanitizeCallbackPath()).setFlow(DefaultHttpCallback.this.flow).build();
        }

        public HttpConnectorDelegate() throws MuleException {
            this.messageSource = new HttpListenerBuilder(DefaultHttpCallback.this.muleContext).setPath(this.sanitizeCallbackPath()).setFlow(DefaultHttpCallback.this.flow).setHost(DefaultHttpCallback.this.domain).setPort(DefaultHttpCallback.this.localPort.intValue()).build();
            this.listenerConfig = this.messageSource.getConfig();
        }

        private String sanitizeCallbackPath() {
            return StringUtils.isBlank((String)DefaultHttpCallback.this.callbackPath) ? "/" : DefaultHttpCallback.this.callbackPath;
        }

        @Override
        public String getScheme() {
            return this.listenerConfig.hasTlsConfig() ? HttpConstants.Protocols.HTTPS.getScheme() : HttpConstants.Protocols.HTTP.getScheme();
        }

        @Override
        public MessageSource getMessageSource() throws MuleException {
            return this.messageSource;
        }

        @Override
        public HttpListenerConfig getConnector() {
            return this.listenerConfig;
        }
    }

    private class OldTransportDelegate
    implements ConnectorDelegate<Connector> {
        private final Connector connector;

        private OldTransportDelegate(Connector connector) {
            this.connector = connector;
        }

        @Override
        public String getScheme() {
            return this.connector.getProtocol();
        }

        @Override
        public MessageSource getMessageSource() throws MuleException {
            return DefaultHttpCallback.this.createHttpInboundEndpoint();
        }

        @Override
        public Connector getConnector() {
            return this.connector;
        }
    }

    private static interface ConnectorDelegate<T> {
        public String getScheme();

        public MessageSource getMessageSource() throws MuleException;

        public T getConnector();
    }

    public class FlowRefMessageProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            return DefaultHttpCallback.this.callbackFlow.process(event);
        }
    }
}

