/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.process;

import java.util.Iterator;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.common.connection.exception.UnableToAcquireConnectionException;
import org.mule.common.connection.exception.UnableToReleaseConnectionException;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.callback.ProcessCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedAccessTokenProcessInterceptor<T>
extends ExpressionEvaluatorSupport
implements ProcessInterceptor<T, OAuth2Adapter> {
    private static Logger logger = LoggerFactory.getLogger(ManagedAccessTokenProcessInterceptor.class);
    private final OAuth2Manager<OAuth2Adapter> oauthManager;
    private final ProcessInterceptor<T, OAuth2Adapter> next;

    public ManagedAccessTokenProcessInterceptor(ProcessInterceptor<T, OAuth2Adapter> next, OAuth2Manager<OAuth2Adapter> oauthManager) {
        this.next = next;
        this.oauthManager = oauthManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T execute(ProcessCallback<T, OAuth2Adapter> processCallback, OAuth2Adapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        T t;
        OAuth2Adapter connector = null;
        if (!processCallback.isProtected()) {
            return processCallback.process(this.oauthManager.getDefaultUnauthorizedConnector());
        }
        String accessTokenId = this.getAccessTokenId(event, messageProcessor, this.oauthManager);
        processCallback.setAccessTokenId(accessTokenId);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Attempting to acquire access token using from store for [accessTokenId=%s]", accessTokenId));
            }
            if ((connector = this.oauthManager.acquireAccessToken(accessTokenId)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Access token has been acquired for [accessTokenId=%s]", accessTokenId));
            }
            t = this.next.execute(processCallback, connector, messageProcessor, event);
        }
        catch (Exception e) {
            try {
                if (processCallback.getManagedExceptions() == null) throw e;
                if (connector == null) throw e;
                Iterator<Class<Exception>> iterator = processCallback.getManagedExceptions().iterator();
                while (iterator.hasNext()) {
                    Class<Exception> exceptionClass = iterator.next();
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("An exception (%s) has been thrown. Destroying the access token with [accessTokenId=%s]", exceptionClass.getName(), accessTokenId));
                    }
                    try {
                        this.oauthManager.destroyAccessToken(accessTokenId, connector);
                        connector = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    if (connector == null) throw throwable;
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Releasing the access token back into the pool [accessTokenId=%s]", accessTokenId));
                    }
                    this.oauthManager.releaseAccessToken(accessTokenId, connector);
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new UnableToReleaseConnectionException((Throwable)e2);
                }
            }
        }
        try {
            if (connector == null) return t;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Releasing the access token back into the pool [accessTokenId=%s]", accessTokenId));
            }
            this.oauthManager.releaseAccessToken(accessTokenId, connector);
            return t;
        }
        catch (Exception e) {
            throw new UnableToReleaseConnectionException((Throwable)e);
        }
    }

    @Override
    public T execute(ProcessCallback<T, OAuth2Adapter> processCallback, OAuth2Adapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

