/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.NonBlockingReplyToHandler;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.cxf.CxfCannotProcessEmptyPayloadException;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.module.cxf.CxfOutboundMessageProcessor;
import org.mule.module.cxf.support.CxfUtils;
import org.mule.module.cxf.support.DelegatingOutputStream;
import org.mule.module.cxf.transport.MuleUniversalTransport;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;

public class MuleUniversalConduit
extends AbstractConduit {
    private static final Logger LOGGER = LogUtils.getL7dLogger(MuleUniversalConduit.class);
    private EndpointInfo endpoint;
    private CxfConfiguration configuration;
    private MuleUniversalTransport transport;
    private boolean closeInput = true;
    private Map<String, OutboundEndpoint> endpoints = new HashMap<String, OutboundEndpoint>();

    public MuleUniversalConduit(MuleUniversalTransport transport, CxfConfiguration configuration, EndpointInfo ei, EndpointReferenceType t) {
        super(MuleUniversalConduit.getTargetReference(ei, t));
        this.transport = transport;
        this.endpoint = ei;
        this.configuration = configuration;
    }

    public void close(Message msg) throws IOException {
        InputStream in;
        OutputStream os = (OutputStream)msg.getContent(OutputStream.class);
        if (os != null) {
            os.close();
        }
        if (this.closeInput && (in = (InputStream)msg.getContent(InputStream.class)) != null) {
            in.close();
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public void prepare(final Message message) throws IOException {
        final ByteArrayOutputStream cache = new ByteArrayOutputStream();
        final DelegatingOutputStream delegating = new DelegatingOutputStream(cache);
        message.setContent(OutputStream.class, (Object)delegating);
        message.setContent(DelegatingOutputStream.class, (Object)delegating);
        OutputHandler handler = new OutputHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(MuleEvent event, OutputStream out) throws IOException {
                OutputStream outputStream = delegating.getOutputStream();
                synchronized (outputStream) {
                    out.write(cache.toByteArray());
                    delegating.setOutputStream(out);
                }
                message.getInterceptorChain().doIntercept(message);
            }
        };
        MuleEvent event = (MuleEvent)message.getExchange().get((Object)"mule.event");
        boolean decoupled = event != null && message.getExchange().getInMessage() != null;
        OutboundEndpoint ep = null;
        if (event == null || VoidMuleEvent.getInstance().equals(event) || decoupled) {
            MuleContext muleContext = this.configuration.getMuleContext();
            DefaultMuleMessage muleMsg = new DefaultMuleMessage((Object)handler, muleContext);
            String url = this.setupURL(message);
            try {
                ep = this.getEndpoint(muleContext, url);
                event = new DefaultMuleEvent((MuleMessage)muleMsg, ep.getExchangePattern(), (FlowConstruct)null);
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
        } else {
            event.getMessage().setPayload((Object)handler, DataTypeFactory.XML_STRING);
        }
        if (!decoupled) {
            message.getExchange().put((Object)"mule.event", (Object)event);
        }
        message.put((Object)"mule.event", (Object)event);
        final MuleEvent finalEvent = event;
        final OutboundEndpoint finalEndpoint = ep;
        AbstractPhaseInterceptor<Message> i = new AbstractPhaseInterceptor<Message>("pre-stream"){

            public void handleMessage(Message m) throws Fault {
                try {
                    MuleUniversalConduit.this.dispatchMuleMessage(m, finalEvent, finalEndpoint);
                }
                catch (MuleException e) {
                    throw new Fault((Throwable)e);
                }
            }
        };
        message.getInterceptorChain().add((Interceptor)i);
    }

    protected synchronized OutboundEndpoint getEndpoint(MuleContext muleContext, String uri) throws MuleException {
        if (this.endpoints.get(uri) != null) {
            return this.endpoints.get(uri);
        }
        OutboundEndpoint endpoint = muleContext.getEndpointFactory().getOutboundEndpoint(uri);
        this.endpoints.put(uri, endpoint);
        return endpoint;
    }

    public String setupURL(Message message) throws MalformedURLException {
        int slashIdx;
        String result;
        String value = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        String pathInfo = (String)message.get((Object)Message.PATH_INFO);
        String queryString = (String)message.get((Object)Message.QUERY_STRING);
        String username = (String)message.get((Object)"javax.xml.ws.security.auth.username");
        String password = (String)message.get((Object)"javax.xml.ws.security.auth.password");
        String string = result = value != null ? value : this.getTargetOrEndpoint();
        if (username != null && (slashIdx = result.indexOf("//")) != -1) {
            result = result.substring(0, slashIdx + 2) + username + ":" + password + "@" + result.substring(slashIdx + 2);
        }
        if (null != pathInfo && !result.endsWith(pathInfo)) {
            result = result + pathInfo;
        }
        if (queryString != null) {
            result = result + "?" + queryString;
        }
        return result;
    }

    protected void dispatchMuleMessage(final Message m, MuleEvent reqEvent, OutboundEndpoint endpoint) throws MuleException {
        try {
            MuleMessage req = reqEvent.getMessage();
            req.setOutboundProperty("http.disable.status.code.exception.check", (Object)Boolean.TRUE.toString());
            if (reqEvent.isAllowNonBlocking()) {
                final ReplyToHandler originalReplyToHandler = reqEvent.getReplyToHandler();
                reqEvent = new DefaultMuleEvent(reqEvent, (ReplyToHandler)new NonBlockingReplyToHandler(){

                    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
                        try {
                            Holder holder = (Holder)m.getExchange().get((Object)"holder");
                            holder.value = event;
                            MuleUniversalConduit.this.sendResultBackToCxf(m, event);
                        }
                        catch (IOException | CxfCannotProcessEmptyPayloadException e) {
                            this.processExceptionReplyTo(new MessagingException(event, (Throwable)e), replyTo);
                        }
                    }

                    public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
                        originalReplyToHandler.processExceptionReplyTo(exception, replyTo);
                    }
                });
            }
            OptimizedRequestContext.unsafeSetEvent((MuleEvent)reqEvent);
            MuleEvent resEvent = this.processNext(reqEvent, m.getExchange(), endpoint);
            if (!resEvent.equals(NonBlockingVoidMuleEvent.getInstance())) {
                this.sendResultBackToCxf(m, resEvent);
            }
        }
        catch (MuleException me) {
            throw me;
        }
        catch (CxfCannotProcessEmptyPayloadException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        catch (Exception e) {
            throw new DefaultMuleException(MessageFactory.createStaticMessage((String)"Could not send message to Mule."), (Throwable)e);
        }
    }

    private void sendResultBackToCxf(Message m, MuleEvent resEvent) throws TransformerException, IOException, CxfCannotProcessEmptyPayloadException {
        if (resEvent != null && !VoidMuleEvent.getInstance().equals(resEvent)) {
            m.getExchange().put((Object)"mule.event", (Object)resEvent);
            MuleMessage result = resEvent.getMessage();
            InputStream is = this.getResponseBody(m, result);
            if (is != null) {
                MessageImpl inMessage = new MessageImpl();
                String contentType = (String)result.getInboundProperty("Content-Type", (Object)"text/xml");
                String encoding = CxfUtils.resolveEncoding(result, contentType);
                if (encoding != null) {
                    contentType = contentType + "; charset=" + encoding;
                }
                inMessage.put((Object)Message.ENCODING, (Object)encoding);
                inMessage.put((Object)"Content-Type", (Object)contentType);
                inMessage.setContent(InputStream.class, (Object)is);
                inMessage.setExchange(m.getExchange());
                this.getMessageObserver().onMessage((Message)inMessage);
                CxfUtils.clearClientContextIfNeeded(this.getMessageObserver());
                return;
            }
            if (this.cxfMessageProcessorIsProxy(m) && resEvent.getMessage().getInboundPropertyNames().contains("http.status")) {
                Integer soapServiceResponseStatusCode = Integer.valueOf(resEvent.getMessage().getInboundProperty("http.status").toString());
                Integer resolvedHttpStatusCode = soapServiceResponseStatusCode.equals(202) ? 202 : 500;
                resEvent.getMessage().setOutboundProperty("http.status", (Object)resolvedHttpStatusCode);
                if (resEvent.isAllowNonBlocking() || !resolvedHttpStatusCode.equals(202)) {
                    throw new CxfCannotProcessEmptyPayloadException(soapServiceResponseStatusCode);
                }
            }
        }
        m.getExchange().put((Object)"exchange.finished", (Object)Boolean.TRUE);
    }

    private boolean cxfMessageProcessorIsProxy(Message aMessage) {
        return aMessage.get((Object)"SOAPAction") == null && aMessage.getExchange().get((Object)"cxf_outbound_message_processor") != null && ((CxfOutboundMessageProcessor)((Object)aMessage.getExchange().get((Object)"cxf_outbound_message_processor"))).isProxy();
    }

    protected InputStream getResponseBody(Message m, MuleMessage result) throws TransformerException, IOException {
        boolean response;
        boolean bl = response = result != null && !NullPayload.getInstance().equals(result.getPayload()) && !this.isOneway(m.getExchange());
        if (response) {
            InputStream is = (InputStream)result.getPayload(DataTypeFactory.create(InputStream.class));
            PushbackInputStream pb = new PushbackInputStream(is);
            result.setPayload((Object)pb, DataTypeFactory.XML_STRING);
            int b = pb.read();
            if (b != -1) {
                pb.unread(b);
                return pb;
            }
        }
        return null;
    }

    protected boolean isOneway(Exchange exchange) {
        return exchange != null && exchange.isOneWay();
    }

    protected String getTargetOrEndpoint() {
        if (this.target != null) {
            return this.target.getAddress().getValue();
        }
        return this.endpoint.getAddress();
    }

    public void onClose(Message m) throws IOException {
    }

    protected MuleEvent processNext(MuleEvent event, Exchange exchange, OutboundEndpoint endpoint) throws MuleException {
        MuleEvent response;
        CxfOutboundMessageProcessor processor = (CxfOutboundMessageProcessor)((Object)exchange.get((Object)"cxf_outbound_message_processor"));
        if (processor == null) {
            response = endpoint.process(event);
        } else {
            response = processor.processNext(event);
            Holder holder = (Holder)exchange.get((Object)"holder");
            holder.value = response;
        }
        return response;
    }

    public void close() {
    }

    protected static EndpointReferenceType getTargetReference(EndpointInfo ei, EndpointReferenceType t) {
        EndpointReferenceType ref = null;
        if (null == t) {
            ref = new EndpointReferenceType();
            AttributedURIType address = new AttributedURIType();
            address.setValue(ei.getAddress());
            ref.setAddress(address);
            if (ei.getService() != null) {
                EndpointReferenceUtils.setServiceAndPortName((EndpointReferenceType)ref, (QName)ei.getService().getName(), (String)ei.getName().getLocalPart());
            }
        } else {
            ref = t;
        }
        return ref;
    }

    public void setCloseInput(boolean closeInput) {
        this.closeInput = closeInput;
    }

    protected CxfConfiguration getConnector() {
        return this.configuration;
    }

    protected EndpointInfo getEndpoint() {
        return this.endpoint;
    }

    protected MuleUniversalTransport getTransport() {
        return this.transport;
    }

    protected class InterposedMessageObserver
    implements MessageObserver {
        protected InterposedMessageObserver() {
        }

        public void onMessage(Message inMessage) {
            inMessage.setExchange((Exchange)new ExchangeImpl());
            inMessage.put((Object)"decoupled.channel.message", (Object)Boolean.TRUE);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)200);
            inMessage.remove((Object)"org.apache.cxf.async.post.response.dispatch");
            MuleUniversalConduit.this.incomingObserver.onMessage(inMessage);
            CxfUtils.clearClientContextIfNeeded(MuleUniversalConduit.this.getMessageObserver());
        }
    }
}

