/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SubstringBefore
extends CollatingFunctionFixed {
    private static StringValue substringBefore(XPathContext context, StringValue arg0, StringValue arg1, StringCollator collator) throws XPathException {
        StringValue result;
        String s0 = arg0.getStringValue();
        String s1 = arg1.getStringValue();
        if (collator instanceof CodepointCollator) {
            int j = s0.indexOf(s1);
            result = j < 0 ? StringValue.EMPTY_STRING : new StringValue(s0.substring(0, j));
        } else {
            if (collator instanceof SimpleCollation) {
                collator = ((SimpleCollation)collator).getSubstringMatcher();
            }
            if (collator instanceof SubstringMatcher) {
                result = new StringValue(((SubstringMatcher)collator).substringBefore(s0, s1));
            } else {
                throw new XPathException("The collation requested for substring-before() does not support substring matching", "FOCH0004", context);
            }
        }
        if (arg0.isKnownToContainNoSurrogates()) {
            result.setContainsNoSurrogates();
        }
        return result;
    }

    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue arg1 = (StringValue)arguments[1].head();
        if (arg1 == null || arg1.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        StringValue arg0 = (StringValue)arguments[0].head();
        if (arg0 == null || arg0.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        StringCollator collator = this.getStringCollator();
        return SubstringBefore.substringBefore(context, arg0, arg1, collator);
    }
}

