/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Chain;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;

public class MapForEach
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("", "http://www.w3.org/2005/xpath-functions/map", "for-each");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{HashTrieMap.SINGLE_MAP_TYPE, SequenceType.makeSequenceType(new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_ATOMIC, SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE), 16384)};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                MapItem map = (MapItem)arguments[0].head();
                Function fn = (Function)arguments[1].head();
                ArrayList<GroundedValue> results = new ArrayList<GroundedValue>();
                for (KeyValuePair pair : map) {
                    Sequence seq = fn.call(context, new Sequence[]{pair.key, pair.value});
                    results.add(SequenceTool.toGroundedValue(seq));
                }
                assert (map != null);
                return new Chain(results);
            }
        };
    }
}

