/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.pool.PoolableObjectFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.EndpointURI;

public class FtpConnectionFactory
implements PoolableObjectFactory {
    private EndpointURI uri;
    private int connectionTimeout = 0;
    private int responseTimeout = 0;

    public FtpConnectionFactory(EndpointURI uri) {
        this.uri = uri;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public Object makeObject() throws Exception {
        FTPClient client = this.createFtpClient();
        if (this.uri.getPort() > 0) {
            client.connect(this.uri.getHost(), this.uri.getPort());
        } else {
            client.connect(this.uri.getHost());
        }
        if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
            throw new IOException("Ftp connect failed: " + client.getReplyCode());
        }
        if (!client.login(this.uri.getUser(), this.uri.getPassword())) {
            throw new IOException("Ftp login failed: " + client.getReplyCode());
        }
        if (!client.setFileType(2)) {
            throw new IOException("Ftp error. Couldn't set BINARY transfer type: " + client.getReplyCode());
        }
        return client;
    }

    protected FTPClient createFtpClient() {
        FTPClient ftpClient = new FTPClient();
        ftpClient.setDefaultTimeout(this.connectionTimeout);
        ftpClient.setConnectTimeout(this.connectionTimeout);
        return ftpClient;
    }

    public void destroyObject(Object obj) throws Exception {
        FTPClient client = (FTPClient)obj;
        try {
            client.logout();
        }
        finally {
            client.disconnect();
        }
    }

    public boolean validateObject(Object obj) {
        FTPClient client = (FTPClient)obj;
        try {
            client.setSoTimeout(this.responseTimeout);
            return client.sendNoOp();
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void passivateObject(Object obj) throws Exception {
    }
}

