/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.builder.impl;

import com.envoisolutions.sxc.Context;
import com.envoisolutions.sxc.Reader;
import com.envoisolutions.sxc.builder.BuildException;
import com.envoisolutions.sxc.builder.CodeBody;
import com.envoisolutions.sxc.builder.ElementParserBuilder;
import com.envoisolutions.sxc.builder.ParserBuilder;
import com.envoisolutions.sxc.builder.impl.AbstractParserBuilder;
import com.envoisolutions.sxc.builder.impl.AttributeParserBuilderImpl;
import com.envoisolutions.sxc.builder.impl.BuildContext;
import com.envoisolutions.sxc.builder.impl.CodeBodyImpl;
import com.envoisolutions.sxc.builder.impl.IdentityManager;
import com.envoisolutions.sxc.builder.impl.JBlankLine;
import com.envoisolutions.sxc.builder.impl.JIfElseBlock;
import com.envoisolutions.sxc.builder.impl.JLineComment;
import com.envoisolutions.sxc.util.Attribute;
import com.envoisolutions.sxc.util.XoXMLStreamReader;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.XMLConstants;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementParserBuilderImpl
extends AbstractParserBuilder
implements ElementParserBuilder {
    private final Map<QName, ExpectedAttribute> attributes = new LinkedHashMap<QName, ExpectedAttribute>();
    private ExpectedAttribute anyAttribute;
    private final Map<QName, ExpectedElement> elements = new LinkedHashMap<QName, ExpectedElement>();
    private ExpectedElement anyElement;
    private ExpectedElement mixedElement;
    private final Map<QName, ExpectedXsiType> xsiTypes = new LinkedHashMap<QName, ExpectedXsiType>();
    private ExpectedXsiType unexpectedXsiType;
    private final List<ElementParserBuilderImpl> states = new ArrayList<ElementParserBuilderImpl>();
    private boolean root;
    private int depth = 1;
    private QName name;
    private QName xmlType;
    private JMethod constructor;
    private JInvocation methodInvocation;
    private boolean valueType;
    private boolean checkXsiTypes = true;
    private boolean addReadAsType = true;
    private JForEach forEachAttribute;
    private JForEach forEachChildElement;
    private final JBlock preElementBlock = new JBlock(false, false);
    private JClass baseClass;
    private final JBlock tailBlock = new JBlock(false, false);

    public ElementParserBuilderImpl(BuildContext buildContext, String className) throws BuildException {
        this.buildContext = buildContext;
        this.model = buildContext.getCodeModel();
        try {
            this.readerClass = this.model._class(className);
            this.baseClass = this.model.ref(Reader.class);
        }
        catch (JClassAlreadyExistsException e) {
            throw new BuildException(e);
        }
        this.constructor = this.readerClass.constructor(1);
        this.constructor.body().invoke("super").arg((JExpression)this.constructor.param(Context.class, "context"));
        this.method = this.readerClass.method(9, Object.class, "read");
        this.addBasicArgs(this.method);
        this.method._throws(XMLStreamException.class);
        this.root = true;
        this.reserveVariables();
    }

    public ElementParserBuilderImpl(BuildContext buildContext, JDefinedClass readerClass, Class returnType, boolean mixed) throws BuildException {
        this(buildContext, readerClass, returnType, mixed, 1, null);
    }

    public ElementParserBuilderImpl(BuildContext buildContext, JDefinedClass readerClass, Class returnType, boolean mixed, int depth, String methodNameHint) throws BuildException {
        if (buildContext == null) {
            throw new NullPointerException("buildContext is null");
        }
        if (readerClass == null) {
            throw new NullPointerException("readerClass is null");
        }
        this.buildContext = buildContext;
        this.readerClass = readerClass;
        this.model = buildContext.getCodeModel();
        if (returnType != null) {
            this.returnType = this.model._ref(returnType);
        }
        if (methodNameHint == null) {
            methodNameHint = "";
        }
        this.method = readerClass.method(9, returnType == null ? Void.TYPE : returnType, "read" + IdentityManager.capitalize(methodNameHint));
        this.addBasicArgs(this.method);
        this.depth = depth;
        if (depth == 1) {
            this.root = true;
        }
        this.addReadAsType = false;
        this.forEachAttribute = new JForEach((JType)this.model.ref(Attribute.class), this.variableManager.createId("attribute"), (JExpression)this.getXSR().invoke("getAttributes"));
        this.forEachChildElement = !mixed ? new JForEach((JType)this.model.ref(XoXMLStreamReader.class), this.variableManager.createId("elementReader"), (JExpression)this.getXSR().invoke("getChildElements")) : new JForEach((JType)this.model.ref(XoXMLStreamReader.class), this.variableManager.createId("elementReader"), (JExpression)this.getXSR().invoke("getMixedChildElements"));
        this.reserveVariables();
    }

    public ElementParserBuilderImpl(ElementParserBuilderImpl parent, QName name) {
        this(parent, true, name, null);
    }

    public ElementParserBuilderImpl(ElementParserBuilderImpl parent, boolean increaseDepth, QName name) {
        this(parent, increaseDepth, name, null);
    }

    public ElementParserBuilderImpl(ElementParserBuilderImpl parent, boolean increaseDepth, QName name, String methodNameHint) {
        this.model = parent.getCodeModel();
        this.buildContext = parent.getBuildContext();
        this.readerClass = parent.getReaderClass();
        this.name = name;
        if (methodNameHint == null) {
            methodNameHint = "";
        }
        this.method = this.buildContext.createMethod(this.readerClass, "read" + IdentityManager.capitalize(methodNameHint));
        this.addBasicArgs(this.method);
        this.method._throws(XMLStreamException.class);
        this.depth = increaseDepth ? parent.depth + 1 : parent.depth;
        this.reserveVariables();
    }

    private void reserveVariables() {
        this.variableManager.addId("depth");
        this.variableManager.addId("targetDepth");
        this.variableManager.addId("event");
        this.variableManager.addId("attName");
        this.variableManager.addId("attNs");
        this.variableManager.addId("attValue");
        this.variableManager.addId("xsiType");
    }

    @Override
    public QName getName() {
        return this.name;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public void setXmlType(QName xmlType) {
        this.xmlType = xmlType;
    }

    public JMethod getConstructor() {
        return this.constructor;
    }

    public JClass getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(JClass baseClass) {
        this.baseClass = baseClass;
    }

    public boolean isAddReadAsType() {
        return this.addReadAsType;
    }

    public void setAddReadAsType(boolean addReadAsType) {
        this.addReadAsType = addReadAsType;
    }

    public JVar getAttributeVar() {
        if (this.forEachAttribute == null) {
            return null;
        }
        return this.forEachAttribute.var();
    }

    public JVar getChildElementVar() {
        if (this.forEachChildElement == null) {
            return null;
        }
        return this.forEachChildElement.var();
    }

    @Override
    public ParserBuilder expectAttribute(QName name) {
        if (name == null) {
            throw new NullPointerException("Attribute name cannot be null!");
        }
        ExpectedAttribute expectedAttribute = this.attributes.get(name);
        if (expectedAttribute == null) {
            expectedAttribute = new ExpectedAttribute();
            this.attributes.put(name, expectedAttribute);
        }
        if (expectedAttribute.getParserBuilder() == null) {
            expectedAttribute.setParserBuilder(new AttributeParserBuilderImpl(this));
        }
        return expectedAttribute.getParserBuilder();
    }

    @Override
    public void setAttributeBlock(QName name, JVar readVar, JBlock readBlock) {
        if (name == null) {
            throw new NullPointerException("Attribute name cannot be null!");
        }
        ExpectedAttribute expectedAttribute = this.attributes.get(name);
        if (expectedAttribute == null) {
            expectedAttribute = new ExpectedAttribute();
            this.attributes.put(name, expectedAttribute);
        }
        expectedAttribute.setReadVar(readVar);
        expectedAttribute.setReadBlock(readBlock);
    }

    @Override
    public ParserBuilder expectAnyAttribute() {
        if (this.anyAttribute == null) {
            this.anyAttribute = new ExpectedAttribute();
        }
        if (this.anyAttribute.getParserBuilder() == null) {
            this.anyAttribute.setParserBuilder(new AttributeParserBuilderImpl(this));
        }
        return this.anyAttribute.getParserBuilder();
    }

    @Override
    public void setAnyAttributeBlock(JVar readVar, JBlock readBlock) {
        if (this.anyAttribute == null) {
            this.anyAttribute = new ExpectedAttribute();
        }
        this.anyAttribute.setReadVar(readVar);
        this.anyAttribute.setReadBlock(readBlock);
    }

    @Override
    public ElementParserBuilder expectElement(QName name) {
        return this.expectElement(name, null);
    }

    @Override
    public ElementParserBuilder expectElement(QName name, String methodNameHint) {
        if (name == null) {
            throw new NullPointerException("Element name cannot be null!");
        }
        ExpectedElement expectedElement = this.elements.get(name);
        if (expectedElement == null) {
            expectedElement = new ExpectedElement();
            this.elements.put(name, expectedElement);
        }
        if (expectedElement.getParserBuilder() == null) {
            expectedElement.setParserBuilder(new ElementParserBuilderImpl(this, true, name, methodNameHint));
        }
        return expectedElement.getParserBuilder();
    }

    @Override
    public void expectElement(QName name, ElementParserBuilder elementBuilder, JExpression ... vars) {
        if (name == null) {
            throw new NullPointerException("Element name cannot be null!");
        }
        ExpectedElement expectedElement = this.elements.get(name);
        if (expectedElement == null) {
            expectedElement = new ExpectedElement();
            this.elements.put(name, expectedElement);
        }
        expectedElement.setParserBuilder((ElementParserBuilderImpl)elementBuilder);
        expectedElement.setVars(vars);
    }

    @Override
    public void setElementBlock(QName name, JVar readVar, JBlock readBlock) {
        if (name == null) {
            throw new NullPointerException("Element name cannot be null!");
        }
        ExpectedElement expectedElement = this.elements.get(name);
        if (expectedElement == null) {
            expectedElement = new ExpectedElement();
            this.elements.put(name, expectedElement);
        }
        expectedElement.setReadVar(readVar);
        expectedElement.setReadBlock(readBlock);
    }

    @Override
    public ElementParserBuilder expectAnyElement() {
        return this.expectAnyElement(null);
    }

    @Override
    public ElementParserBuilder expectAnyElement(String methodNameHint) {
        if (this.anyElement == null) {
            this.anyElement = new ExpectedElement();
        }
        if (this.anyElement.getParserBuilder() == null) {
            this.anyElement.setParserBuilder(new ElementParserBuilderImpl(this, true, null, methodNameHint));
        }
        return this.anyElement.getParserBuilder();
    }

    @Override
    public void setAnyElementBlock(JVar readVar, JBlock readBlock) {
        if (this.anyElement == null) {
            this.anyElement = new ExpectedElement();
        }
        this.anyElement.setReadVar(readVar);
        this.anyElement.setReadBlock(readBlock);
    }

    @Override
    public ElementParserBuilder expectMixedElement() {
        return this.expectMixedElement(null);
    }

    @Override
    public ElementParserBuilder expectMixedElement(String methodNameHint) {
        if (this.mixedElement == null) {
            this.mixedElement = new ExpectedElement();
        }
        if (this.mixedElement.getParserBuilder() == null) {
            this.mixedElement.setParserBuilder(new ElementParserBuilderImpl(this, true, null, methodNameHint));
        }
        return this.mixedElement.getParserBuilder();
    }

    @Override
    public void setMixedElementBlock(JVar readVar, JBlock readBlock) {
        if (this.mixedElement == null) {
            this.mixedElement = new ExpectedElement();
        }
        this.mixedElement.setReadVar(readVar);
        this.mixedElement.setReadBlock(readBlock);
    }

    @Override
    public ElementParserBuilder expectXsiType(QName name) {
        return this.expectXsiType(name, null);
    }

    @Override
    public ElementParserBuilder expectXsiType(QName name, String methodNameHint) {
        if (name == null) {
            throw new NullPointerException("XsiType name cannot be null!");
        }
        ExpectedXsiType expectedXsiType = this.xsiTypes.get(name);
        if (expectedXsiType == null) {
            expectedXsiType = new ExpectedXsiType();
            this.xsiTypes.put(name, expectedXsiType);
        }
        if (expectedXsiType.getParserBuilder() == null) {
            ElementParserBuilderImpl xsiType = new ElementParserBuilderImpl(this, true, name, methodNameHint);
            xsiType.checkXsiTypes = false;
            expectedXsiType.setParserBuilder(xsiType);
        }
        return expectedXsiType.getParserBuilder();
    }

    @Override
    public void setXsiTypeBlock(QName name, JVar readVar, JBlock readBlock) {
        if (name == null) {
            throw new NullPointerException("XsiType name cannot be null!");
        }
        ExpectedXsiType expectedXsiType = this.xsiTypes.get(name);
        if (expectedXsiType == null) {
            expectedXsiType = new ExpectedXsiType();
            this.xsiTypes.put(name, expectedXsiType);
        }
        expectedXsiType.setReadVar(readVar);
        expectedXsiType.setReadBlock(readBlock);
    }

    @Override
    public ElementParserBuilder expectUnexpectedXsiType() {
        return this.expectUnexpectedXsiType(null);
    }

    @Override
    public ElementParserBuilder expectUnexpectedXsiType(String methodNameHint) {
        if (this.unexpectedXsiType == null) {
            this.unexpectedXsiType = new ExpectedXsiType();
        }
        if (this.unexpectedXsiType.getParserBuilder() == null) {
            this.unexpectedXsiType.setParserBuilder(new ElementParserBuilderImpl(this, true, null, methodNameHint));
        }
        return this.unexpectedXsiType.getParserBuilder();
    }

    @Override
    public void setUnexpectedXsiTypeBlock(JVar readVar, JBlock readBlock) {
        if (this.unexpectedXsiType == null) {
            this.unexpectedXsiType = new ExpectedXsiType();
        }
        this.unexpectedXsiType.setReadVar(readVar);
        this.unexpectedXsiType.setReadBlock(readBlock);
    }

    @Override
    public ElementParserBuilder expectGlobalElement(QName qname) {
        return this.expectGlobalElement(qname, null);
    }

    @Override
    public ElementParserBuilder expectGlobalElement(QName qname, String methodNameHint) {
        if (qname == null) {
            throw new NullPointerException("Element name cannot be null!");
        }
        ExpectedElement expectedElement = this.buildContext.getGlobalElements().get(qname);
        if (expectedElement == null) {
            expectedElement = new ExpectedElement();
            this.buildContext.getGlobalElements().put(qname, expectedElement);
        }
        if (expectedElement.getParserBuilder() == null) {
            expectedElement.setParserBuilder(new ElementParserBuilderImpl(this, true, qname, methodNameHint));
        }
        return expectedElement.getParserBuilder();
    }

    @Override
    public JVar as(Class<?> cls) {
        return this.as(cls, false);
    }

    @Override
    public JVar as(Class<?> cls, boolean nillable) {
        this.valueType = true;
        if (cls.equals(String.class)) {
            return this.createVar("getElementAsString", String.class, nillable);
        }
        if (cls.equals(Integer.TYPE) || cls.equals(Integer.class)) {
            return this.createVar("getElementAsInt", cls, nillable);
        }
        if (cls.equals(Double.TYPE) || cls.equals(Double.class)) {
            return this.createVar("getElementAsDouble", cls, nillable);
        }
        if (cls.equals(Float.TYPE) || cls.equals(Float.class)) {
            return this.createVar("getElementAsFloat", cls, nillable);
        }
        if (cls.equals(Long.TYPE) || cls.equals(Long.class)) {
            return this.createVar("getElementAsLong", cls, nillable);
        }
        if (cls.equals(Short.TYPE) || cls.equals(Short.class)) {
            return this.createVar("getElementAsShort", cls, nillable);
        }
        if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
            return this.createVar("getElementAsBoolean", cls, nillable);
        }
        if (cls.equals(Byte.TYPE) || cls.equals(Byte.class)) {
            return this.createVar("getElementAsByte", cls, nillable);
        }
        throw new UnsupportedOperationException("Invalid type " + cls);
    }

    private JVar createVar(String method, Class<?> cls, boolean nillable) {
        JVar var;
        String name = this.variableManager.createId("value");
        if (!cls.isPrimitive() && nillable) {
            var = this.method.body().decl(this.model._ref(cls), name, JExpr._null());
            JConditional cond = this.method.body()._if(this.xsrVar.invoke("isXsiNil").not());
            JInvocation invocation = this.xsrVar.invoke(method);
            cond._then().assign((JAssignmentTarget)var, (JExpression)invocation);
        } else {
            var = this.method.body().decl(this.model._ref(cls), name, (JExpression)this.xsrVar.invoke(method));
        }
        return var;
    }

    public JVar asString() {
        return this.as(String.class, false);
    }

    @Override
    public ElementParserBuilder newState() {
        return this.newState(this.preElementBlock);
    }

    @Override
    public ElementParserBuilder newState(JBlock block) {
        return this.newState(block, null);
    }

    @Override
    public ElementParserBuilder newState(JBlock block, String methodNameHint) {
        JInvocation invocation;
        ElementParserBuilderImpl b = new ElementParserBuilderImpl(this, false, this.name, methodNameHint);
        this.states.add(b);
        JMethod nextMethod = b.getMethod();
        b.methodInvocation = invocation = JExpr.invoke((JMethod)nextMethod).arg((JExpression)this.xsrVar).arg((JExpression)this.rtContextVar);
        block.add((JStatement)invocation);
        return b;
    }

    @Override
    public JVar passParentVariable(JVar parentVar) {
        if (this.methodInvocation != null) {
            this.methodInvocation.arg((JExpression)parentVar);
        }
        return super.passParentVariable(parentVar);
    }

    @Override
    public JVar call(JType type, String varName, ElementParserBuilder builder) {
        JBlock block = this.preElementBlock;
        ElementParserBuilderImpl b = (ElementParserBuilderImpl)builder;
        JMethod nextMethod = b.getMethod();
        JInvocation invocation = JExpr.invoke((JMethod)nextMethod).arg((JExpression)this.xsrVar).arg((JExpression)this.rtContextVar);
        for (JVar v : b.variables) {
            invocation.arg((JExpression)v);
        }
        varName = this.variableManager.createId(varName);
        return block.decl(type, varName, (JExpression)invocation);
    }

    @Override
    public CodeBody getBody() {
        return new CodeBodyImpl(this){

            public JBlock getBlock() {
                return ElementParserBuilderImpl.this.preElementBlock;
            }
        };
    }

    @Override
    public JBlock getTailBlock() {
        return this.tailBlock;
    }

    @Override
    public void write() {
        if (this.written) {
            return;
        }
        this.written = true;
        JBlock b = this.method.body();
        if (!(this.valueType || this.elements.size() <= 0 && this.buildContext.getGlobalElements().size() <= 0 && this.xsiTypes.size() <= 0 && this.attributes.size() <= 0 && this.unexpectedXsiType == null && this.anyAttribute == null && this.anyElement == null && this.mixedElement == null)) {
            this.writeMainLoop();
        } else {
            b.add((JStatement)ElementParserBuilderImpl.removeBraces(this.codeBlock));
            this.codeBlock.add((JStatement)ElementParserBuilderImpl.removeBraces(this.preElementBlock));
        }
        for (ElementParserBuilderImpl e : this.states) {
            e.write();
        }
        if (!this.tailBlock.getContents().isEmpty()) {
            this.preElementBlock.add((JStatement)ElementParserBuilderImpl.removeBraces(this.tailBlock));
        }
        if (this.returnType != null && this._return != null) {
            this.preElementBlock.add((JStatement)new JBlankLine());
            this.setReturnType(this.returnType);
            this.preElementBlock._return(this._return);
        }
        if (this.root && this.returnType == null) {
            b.add((JStatement)new JBlankLine());
            b._return(JExpr._null());
        }
        if (this.root) {
            this.writeReadAsType();
            if (this.baseClass != null) {
                this.readerClass._extends(this.baseClass);
            }
        }
    }

    protected void writeReadAsType() {
        if (!this.addReadAsType) {
            return;
        }
        JMethod m = this.getReaderClass().method(1, Object.class, "read");
        m.param(XoXMLStreamReader.class, "reader");
        m.param((JType)this.buildContext.getMarshalContextClass(), "context");
        JVar typeVar = m.param(QName.class, "type");
        m._throws(XMLStreamException.class);
        JBlock block = m.body();
        this.writeXsiChecks(block, typeVar);
        block.add((JStatement)new JBlankLine());
        block._return(JExpr._null());
    }

    private void writeMainLoop() {
        JBlock b = this.method.body();
        if (this.returnType != null || !this.valueType && this.depth > 1) {
            this.writeXsiChecks(b);
        }
        b.add((JStatement)this.codeBlock);
        b = this.codeBlock;
        this.writeAttributeReader(b);
        b.add((JStatement)this.preElementBlock);
        b = this.preElementBlock;
        if (!this.elements.isEmpty() || !this.xsiTypes.isEmpty() || this.anyElement != null || this.mixedElement != null || this.allowUnknown) {
            b.add((JStatement)new JBlankLine());
            b.add((JStatement)new JLineComment("Read elements"));
            if (this.forEachChildElement != null && !this.allowUnknown) {
                b.add((JStatement)this.forEachChildElement);
                this.writeElementReader(this.elements, this.forEachChildElement.body(), this.forEachChildElement.var(), false);
            } else {
                JVar targetDepthVar = b.decl(this.model._ref(Integer.TYPE), "targetDepth", this.xsrVar.invoke("getDepth").plus(JExpr.lit((int)1)));
                JVar event = b.decl(this.model._ref(Integer.TYPE), "event", (JExpression)this.xsrVar.invoke("nextTagIgnoreAll"));
                JVar depthVar = b.decl(this.model._ref(Integer.TYPE), "depth", (JExpression)this.xsrVar.invoke("getDepth"));
                JBlock loop = b._while(depthVar.gte(targetDepthVar.minus(JExpr.lit((int)1)))).body();
                b = loop._if(event.eq(JExpr.lit((int)1)))._then();
                JConditional ifDepth = b._if(depthVar.eq((JExpression)targetDepthVar));
                HashMap<QName, ExpectedElement> globalAndLocalEls = new HashMap<QName, ExpectedElement>();
                globalAndLocalEls.putAll(this.elements);
                globalAndLocalEls.putAll(this.buildContext.getGlobalElements());
                this.writeElementReader(globalAndLocalEls, ifDepth._then(), this.xsrVar, false);
                if (this.allowUnknown) {
                    this.writeElementReader(this.buildContext.getGlobalElements(), ifDepth._else(), this.xsrVar, true);
                }
                JConditional ifHasNext = loop._if((JExpression)this.xsrVar.invoke("hasNext"));
                ifHasNext._then().assign((JAssignmentTarget)event, (JExpression)this.xsrVar.invoke("next"));
                ifHasNext._then().assign((JAssignmentTarget)depthVar, (JExpression)this.xsrVar.invoke("getDepth"));
                ifHasNext._else()._break();
            }
        }
        ElementParserBuilderImpl.removeBraces(this.preElementBlock);
    }

    private void writeAttributeReader(JBlock b) {
        JInvocation attValue;
        JInvocation attNs;
        JInvocation attName;
        if (this.attributes.isEmpty() && this.anyAttribute == null) {
            return;
        }
        b.add((JStatement)new JBlankLine());
        b.add((JStatement)new JLineComment("Read attributes"));
        if (this.forEachAttribute != null) {
            b.add((JStatement)this.forEachAttribute);
            b = this.forEachAttribute.body();
            JVar attributeVar = this.forEachAttribute.var();
            attName = attributeVar.invoke("getLocalName");
            attNs = attributeVar.invoke("getNamespace");
            attValue = attributeVar.invoke("getValue");
        } else {
            JForLoop loop = b._for();
            JVar var = loop.init(this.model._ref(Integer.TYPE), "i", JExpr.lit((int)0));
            loop.test(var.lt((JExpression)this.xsrVar.invoke("getAttributeCount")));
            loop.update(var.assignPlus(JExpr.lit((int)1)));
            b = loop.body();
            attName = b.decl(this.model._ref(String.class), "attName", (JExpression)this.xsrVar.invoke("getAttributeLocalName").arg((JExpression)var));
            attNs = b.decl(this.model._ref(String.class), "attNs", (JExpression)this.xsrVar.invoke("getAttributeNamespace").arg((JExpression)var));
            attValue = b.decl(this.model._ref(String.class), "attValue", (JExpression)this.xsrVar.invoke("getAttributeValue").arg((JExpression)var));
        }
        JIfElseBlock attributesBlock = new JIfElseBlock();
        b.add((JStatement)attributesBlock);
        for (Map.Entry<QName, ExpectedAttribute> e : this.attributes.entrySet()) {
            QName name = e.getKey();
            ExpectedAttribute expectedAttribute = e.getValue();
            JExpression qnameCompare = this.buildQNameCompare(name, (JExpression)attName, (JExpression)attNs);
            JBlock block = attributesBlock.addCondition(qnameCompare);
            ArrayList<JInvocation> vars = null;
            if (expectedAttribute.getParserBuilder() != null) {
                AttributeParserBuilderImpl builder = expectedAttribute.getParserBuilder();
                builder.getMethod().param(this.model._ref(String.class), "_attValue");
                vars = new ArrayList<JInvocation>(builder.variables);
                vars.add(attValue);
                builder.getMethod().body().add((JStatement)builder.codeBlock);
            }
            this.writeReader(block, this.xsrVar, expectedAttribute, vars);
        }
        if (this.anyAttribute != null) {
            JBlock block = attributesBlock.addCondition(this.model.ref(XMLConstants.class).staticRef("W3C_XML_SCHEMA_INSTANCE_NS_URI").ne((JExpression)attNs));
            this.writeReader(block, this.xsrVar, this.anyAttribute, null);
        }
    }

    private void writeXsiChecks(JBlock b) {
        if (this.xsiTypes.isEmpty() && this.unexpectedXsiType == null) {
            return;
        }
        b.add((JStatement)new JBlankLine());
        b.add((JStatement)new JLineComment("Check xsi:type"));
        JVar xsiType = b.decl(this.model._ref(QName.class), "xsiType", (JExpression)this.xsrVar.invoke("getXsiType"));
        JConditional cond = b._if(xsiType.ne(JExpr._null()));
        this.writeXsiChecks(cond._then(), xsiType);
    }

    private void writeXsiChecks(JBlock block, JVar xsiType) {
        JIfElseBlock xsiTypesBlock = new JIfElseBlock();
        block.add((JStatement)xsiTypesBlock);
        for (Map.Entry<QName, ExpectedXsiType> entry : this.xsiTypes.entrySet()) {
            QName name = entry.getKey();
            ExpectedXsiType expectedXsiType = entry.getValue();
            JExpression qnameCompare = this.buildQNameCompare(name, (JExpression)xsiType.invoke("getLocalPart"), (JExpression)xsiType.invoke("getNamespaceURI"));
            JBlock xsiTypeBlock = xsiTypesBlock.addCondition(qnameCompare);
            this.writeReader(xsiTypeBlock, this.xsrVar, expectedXsiType, null);
            ElementParserBuilderImpl parserBuilder = expectedXsiType.getParserBuilder();
            if (parserBuilder == null || expectedXsiType.getParserBuilder().returnType != null) continue;
            xsiTypeBlock._return();
        }
        if (this.unexpectedXsiType != null) {
            JBlock anyBlock = block;
            if (this.xmlType != null) {
                JExpression localInv = JExpr.lit((String)this.xmlType.getLocalPart()).ne((JExpression)xsiType.invoke("getLocalPart"));
                JExpression nsInv = JExpr.lit((String)this.xmlType.getNamespaceURI()).ne((JExpression)xsiType.invoke("getNamespaceURI"));
                if (this.xmlType.getNamespaceURI().equals("")) {
                    nsInv = nsInv.cand(xsiType.invoke("getNamespaceURI").ne(JExpr._null()));
                }
                JExpression qnameCompare = localInv.cor(nsInv);
                anyBlock = xsiTypesBlock.addCondition(qnameCompare);
            } else if (!xsiTypesBlock.ifConditions().isEmpty()) {
                anyBlock = xsiTypesBlock._else().block();
            }
            this.writeReader(anyBlock, this.xsrVar, this.unexpectedXsiType, null);
        }
    }

    private void writeElementReader(Map<QName, ExpectedElement> elements, JBlock block, JVar xsrVar, boolean global) {
        if (this.depth == 1 && !global && this.checkXsiTypes && this.returnType == null) {
            this.writeXsiChecks(block);
        }
        JIfElseBlock elementsBlock = new JIfElseBlock();
        block.add((JStatement)elementsBlock);
        if (this.mixedElement != null) {
            JBlock stringBlock = elementsBlock.addCondition((JExpression)xsrVar.invoke("isCharacters"));
            this.writeReader(stringBlock, xsrVar, this.mixedElement, null);
        }
        for (Map.Entry<QName, ExpectedElement> entry : elements.entrySet()) {
            QName name = entry.getKey();
            ExpectedElement expectedElement = entry.getValue();
            JExpression qnameCompare = this.buildQNameCompare(name, (JExpression)xsrVar.invoke("getLocalName"), (JExpression)xsrVar.invoke("getNamespaceURI"));
            JBlock elementBlock = elementsBlock.addCondition(qnameCompare);
            this.writeReader(elementBlock, xsrVar, expectedElement, expectedElement.getVars());
        }
        if (this.anyElement != null) {
            JBlock anyBlock = block;
            if (!elementsBlock.ifConditions().isEmpty()) {
                anyBlock = elementsBlock._else().block();
            }
            this.writeReader(anyBlock, xsrVar, this.anyElement, null);
        }
    }

    private void writeReader(JBlock block, JVar xsrVar, Expected expected, List<? extends JExpression> vars) {
        JBlock readBlock = expected.getReadBlock();
        AbstractParserBuilder builder = expected.getParserBuilder();
        if (builder != null) {
            JMethod readMethod = builder.getMethod();
            JInvocation invocation = JExpr.invoke((JMethod)readMethod).arg((JExpression)xsrVar).arg((JExpression)this.rtContextVar);
            if (vars == null) {
                vars = builder.getVariables();
            }
            if (vars != null) {
                for (JExpression jExpression : vars) {
                    invocation.arg(jExpression);
                }
            }
            if (readBlock != null) {
                if (expected.getReadVar() != null) {
                    JVar readVar = expected.getReadVar();
                    readVar.init((JExpression)invocation);
                } else {
                    readBlock.add((JStatement)invocation);
                }
                block.add((JStatement)ElementParserBuilderImpl.removeBraces(readBlock));
            } else if (this.root && builder.returnType != null) {
                block._return((JExpression)invocation);
            } else {
                block.add((JStatement)invocation);
            }
            if (builder != this) {
                builder.write();
            }
        } else if (readBlock != null) {
            block.add((JStatement)ElementParserBuilderImpl.removeBraces(readBlock));
        }
    }

    private JExpression buildQNameCompare(QName name, JExpression localPart, JExpression namespaceUri) {
        JExpression localInv = JExpr.lit((String)name.getLocalPart()).eq(localPart);
        String ns = name.getNamespaceURI();
        JExpression nsInv = JExpr.lit((String)ns).eq(namespaceUri);
        if (ns.equals("")) {
            nsInv = nsInv.cor(namespaceUri.eq(JExpr._null()));
        }
        JExpression qnameCompare = localInv.cand(nsInv);
        return qnameCompare;
    }

    private void setReturnType(JType type) {
        try {
            Field field = JMethod.class.getDeclaredField("type");
            boolean accessibility = field.isAccessible();
            field.setAccessible(true);
            field.set(this.method, type);
            field.setAccessible(accessibility);
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    private static JBlock removeBraces(JBlock block) {
        try {
            Field field = JBlock.class.getDeclaredField("bracesRequired");
            field.setAccessible(true);
            field.setBoolean(block, false);
            field = JBlock.class.getDeclaredField("indentRequired");
            field.setAccessible(true);
            field.setBoolean(block, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return block;
    }

    public static class ExpectedXsiType
    implements Expected {
        private ElementParserBuilderImpl parserBuilder;
        private JVar readVar;
        private JBlock readBlock;

        public ElementParserBuilderImpl getParserBuilder() {
            return this.parserBuilder;
        }

        public void setParserBuilder(ElementParserBuilderImpl parserBuilder) {
            this.parserBuilder = parserBuilder;
        }

        public JVar getReadVar() {
            return this.readVar;
        }

        public void setReadVar(JVar readVar) {
            this.readVar = readVar;
        }

        public JBlock getReadBlock() {
            return this.readBlock;
        }

        public void setReadBlock(JBlock readBlock) {
            this.readBlock = readBlock;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpectedElement
    implements Expected {
        private ElementParserBuilderImpl parserBuilder;
        private List<JExpression> vars;
        private JVar readVar;
        private JBlock readBlock;

        @Override
        public ElementParserBuilderImpl getParserBuilder() {
            return this.parserBuilder;
        }

        public void setParserBuilder(ElementParserBuilderImpl parserBuilder) {
            this.parserBuilder = parserBuilder;
        }

        public List<JExpression> getVars() {
            return this.vars;
        }

        public void setVars(List<JExpression> vars) {
            this.vars = vars;
        }

        public void setVars(JExpression ... vars) {
            this.vars = new ArrayList<JExpression>(Arrays.asList(vars));
        }

        @Override
        public JVar getReadVar() {
            return this.readVar;
        }

        public void setReadVar(JVar readVar) {
            this.readVar = readVar;
        }

        @Override
        public JBlock getReadBlock() {
            return this.readBlock;
        }

        public void setReadBlock(JBlock readBlock) {
            this.readBlock = readBlock;
        }
    }

    public static class ExpectedAttribute
    implements Expected {
        private AttributeParserBuilderImpl parserBuilder;
        private JVar readVar;
        private JBlock readBlock;

        public AttributeParserBuilderImpl getParserBuilder() {
            return this.parserBuilder;
        }

        public void setParserBuilder(AttributeParserBuilderImpl parserBuilder) {
            this.parserBuilder = parserBuilder;
        }

        public JBlock getReadBlock() {
            return this.readBlock;
        }

        public void setReadBlock(JBlock readBlock) {
            this.readBlock = readBlock;
        }

        public JVar getReadVar() {
            return this.readVar;
        }

        public void setReadVar(JVar readVar) {
            this.readVar = readVar;
        }
    }

    public static interface Expected {
        public AbstractParserBuilder getParserBuilder();

        public JBlock getReadBlock();

        public JVar getReadVar();
    }
}

