/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ListenerSubscriptionPair;
import org.mule.context.notification.Sender;

class Policy {
    private Map<Class<? extends ServerNotification>, Collection<Sender>> eventToSenders = new HashMap<Class<? extends ServerNotification>, Collection<Sender>>();
    private Map<Class<? extends ServerNotification>, Collection<Sender>> concreteEventToSenders = new HashMap<Class<? extends ServerNotification>, Collection<Sender>>();
    private ConcurrentMap<Class, Boolean> knownEventsExact = new ConcurrentHashMap<Class, Boolean>();
    private ConcurrentMap<Class, Boolean> knownEventsSuper = new ConcurrentHashMap<Class, Boolean>();

    Policy(Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> interfaceToEvents, Set<ListenerSubscriptionPair> listenerSubscriptionPairs, Set<Class<? extends ServerNotificationListener>> disabledInterfaces, Set<Class<? extends ServerNotification>> disabledEvents) {
        for (ListenerSubscriptionPair pair : listenerSubscriptionPairs) {
            ServerNotificationListener listener = pair.getListener();
            for (Class<? extends ServerNotificationListener> iface : interfaceToEvents.keySet()) {
                if (!Policy.notASubclassOfAnyClassInSet(disabledInterfaces, iface) || !iface.isAssignableFrom(listener.getClass())) continue;
                Set<Class<? extends ServerNotification>> events = interfaceToEvents.get(iface);
                for (Class<? extends ServerNotification> event : events) {
                    if (!Policy.notASubclassOfAnyClassInSet(disabledEvents, event)) continue;
                    this.knownEventsExact.put(event, Boolean.TRUE);
                    this.knownEventsSuper.put(event, Boolean.TRUE);
                    if (!this.eventToSenders.containsKey(event)) {
                        this.eventToSenders.put(event, new ArrayList());
                    }
                    this.eventToSenders.get(event).add(new Sender(pair));
                }
            }
        }
    }

    protected static boolean notASubclassOfAnyClassInSet(Set set, Class clazz) {
        for (Class disabled : set) {
            if (!disabled.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    protected static boolean notASuperclassOfAnyClassInSet(Set set, Class clazz) {
        for (Class disabled : set) {
            if (!clazz.isAssignableFrom(disabled)) continue;
            return false;
        }
        return true;
    }

    void dispatch(ServerNotification notification) {
        if (null != notification) {
            boolean found;
            Class<?> notfnClass = notification.getClass();
            Boolean eventKnown = (Boolean)this.knownEventsExact.get(notfnClass);
            if (eventKnown == null) {
                boolean found2 = this.doDispatch(notification, notfnClass);
                this.knownEventsExact.put(notfnClass, found2);
            } else if (eventKnown.booleanValue() && !(found = this.doDispatch(notification, notfnClass))) {
                this.knownEventsExact.put(notfnClass, found);
            }
        }
    }

    protected boolean doDispatch(ServerNotification notification, Class<? extends ServerNotification> notfnClass) {
        boolean found = false;
        Collection<Sender> senders = this.concreteEventToSenders.get(notfnClass);
        if (senders != null) {
            found = true;
            this.dispatchToSenders(notification, senders);
        } else {
            senders = this.concreteEventToSenders.get(notfnClass);
            if (senders != null) {
                this.dispatchToSenders(notification, senders);
            } else {
                senders = new ArrayList<Sender>();
                for (Map.Entry<Class<? extends ServerNotification>, Collection<Sender>> event : this.eventToSenders.entrySet()) {
                    if (!event.getKey().isAssignableFrom(notfnClass)) continue;
                    found = true;
                    senders.addAll(event.getValue());
                    this.dispatchToSenders(notification, senders);
                }
                if (!this.concreteEventToSenders.containsKey(notfnClass)) {
                    this.concreteEventToSenders.put(notfnClass, senders);
                }
            }
        }
        return found;
    }

    private void dispatchToSenders(ServerNotification notification, Collection<Sender> senders) {
        for (Sender sender : senders) {
            try {
                sender.dispatch(notification);
            }
            catch (Exception exception) {}
        }
    }

    boolean isNotificationEnabled(Class notfnClass) {
        Boolean knownExact;
        Boolean knownSuper = (Boolean)this.knownEventsSuper.get(notfnClass);
        if (knownSuper == null) {
            boolean found = false;
            Iterator events = this.knownEventsSuper.keySet().iterator();
            while (events.hasNext() && !found) {
                Class event = (Class)events.next();
                found = (Boolean)this.knownEventsSuper.get(event) != false && notfnClass.isAssignableFrom(event);
            }
            knownSuper = found;
            this.knownEventsSuper.put(notfnClass, knownSuper);
        }
        if ((knownExact = (Boolean)this.knownEventsExact.get(notfnClass)) == null) {
            boolean found = false;
            Iterator<Class<? extends ServerNotification>> events = this.eventToSenders.keySet().iterator();
            while (events.hasNext() && !found) {
                Class<? extends ServerNotification> event = events.next();
                found = event.isAssignableFrom(notfnClass);
            }
            knownExact = found;
            this.knownEventsExact.put(notfnClass, knownExact);
        }
        return knownSuper != false || knownExact != false;
    }
}

