/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.RoutingStrategy;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

public abstract class AbstractRoutingStrategy
implements RoutingStrategy {
    protected static List<String> magicProperties = Arrays.asList("MULE_CORRELATION_ID", "MULE_CORRELATION_ID", "MULE_CORRELATION_GROUP_SIZE", "MULE_CORRELATION_SEQUENCE", "MULE_SESSION");
    protected static transient Log logger = LogFactory.getLog(AbstractRoutingStrategy.class);
    private final MuleContext muleContext;

    public AbstractRoutingStrategy(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected final MuleEvent sendRequest(MuleEvent routedEvent, MuleMessage message, MessageProcessor route, boolean awaitResponse) throws MuleException {
        MuleEvent result;
        block13: {
            if (logger.isDebugEnabled()) {
                if (route instanceof OutboundEndpoint) {
                    logger.debug((Object)("Message being sent to: " + ((OutboundEndpoint)route).getEndpointURI()));
                }
                logger.debug((Object)message);
            }
            if (logger.isTraceEnabled()) {
                try {
                    logger.trace((Object)("Request payload: \n" + StringMessageUtils.truncate(message.getPayloadForLogging(), 100, false)));
                    if (route instanceof OutboundEndpoint) {
                        logger.trace((Object)("outbound transformer is: " + ((OutboundEndpoint)route).getTransformers()));
                    }
                }
                catch (Exception e) {
                    logger.trace((Object)("Request payload: \n(unable to retrieve payload: " + e.getMessage()));
                    if (!(route instanceof OutboundEndpoint)) break block13;
                    logger.trace((Object)("outbound transformer is: " + ((OutboundEndpoint)route).getTransformers()));
                }
            }
        }
        try {
            result = this.sendRequestEvent(routedEvent, message, route, awaitResponse);
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (Exception e) {
            throw new RoutingException(routedEvent, null, (Throwable)e);
        }
        if (result != null && !VoidMuleEvent.getInstance().equals(result)) {
            MuleMessage resultMessage = result.getMessage();
            if (logger.isTraceEnabled() && resultMessage != null) {
                try {
                    logger.trace((Object)("Response payload: \n" + StringMessageUtils.truncate(resultMessage.getPayloadForLogging(), 100, false)));
                }
                catch (Exception e) {
                    logger.trace((Object)("Response payload: \n(unable to retrieve payload: " + e.getMessage()));
                }
            }
        }
        return result;
    }

    private MuleEvent sendRequestEvent(MuleEvent routedEvent, MuleMessage message, MessageProcessor route, boolean awaitResponse) throws MuleException {
        int timeout;
        if (route == null) {
            throw new DispatchException(CoreMessages.objectIsNull("Outbound Endpoint"), routedEvent, null);
        }
        MuleEvent event = this.createEventToRoute(routedEvent, message, route);
        if (awaitResponse && (timeout = message.getOutboundProperty("MULE_EVENT_TIMEOUT", -1).intValue()) >= 0) {
            event.setTimeout(timeout);
        }
        return route.process(event);
    }

    protected MuleEvent createEventToRoute(MuleEvent routedEvent, MuleMessage message, MessageProcessor route) {
        return new DefaultMuleEvent(message, routedEvent, true);
    }

    public static MuleMessage cloneMessage(MuleMessage message, MuleContext muleContext) {
        return new DefaultMuleMessage(message.getPayload(), message, muleContext);
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }

    public static void propagateMagicProperties(MuleMessage in, MuleMessage out) {
        for (String name : magicProperties) {
            Object value = in.getInboundProperty(name);
            if (value == null) continue;
            out.setOutboundProperty(name, value);
        }
    }

    public static void validateMessageIsNotConsumable(MuleEvent event, MuleMessage message) throws MessagingException {
        if (ClassUtils.isConsumable(message.getPayload().getClass())) {
            throw new MessagingException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getClass().getName()), event);
        }
    }

    public static MuleMessage cloneMessage(MuleEvent event, MuleMessage message, MuleContext muleContext) throws MessagingException {
        AbstractRoutingStrategy.assertNonConsumableMessage(event, message);
        return AbstractRoutingStrategy.cloneMessage(message, muleContext);
    }

    protected static void assertNonConsumableMessage(MuleEvent event, MuleMessage message) throws MessagingException {
        if (ClassUtils.isConsumable(message.getPayload().getClass())) {
            throw new MessagingException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getClass().getName()), event);
        }
    }
}

