/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.collections.IteratorUtils;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.PartitionableObjectStore;
import org.mule.routing.WrapperOrderEvent;
import org.mule.session.DefaultMuleSession;
import org.mule.util.ClassUtils;
import org.mule.util.store.DeserializationPostInitialisable;

public class EventGroup
implements Comparable<EventGroup>,
Serializable,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 953739659615692697L;
    public static final MuleEvent[] EMPTY_EVENTS_ARRAY = new MuleEvent[0];
    public static final String MULE_ARRIVAL_ORDER_PROPERTY = "MULE_ARRIVAL_ORDER";
    private final Object groupId;
    private transient PartitionableObjectStore<WrapperOrderEvent> eventsObjectStore;
    private final String storePrefix;
    private final String eventsPartitionKey;
    private final long created = System.currentTimeMillis();
    private final int expectedSize;
    private transient MuleContext muleContext;
    private String commonRootId = null;
    private static boolean hasNoCommonRootId = false;
    private Serializable lastStoredEventKey;
    public static final String DEFAULT_STORE_PREFIX = "DEFAULT_STORE";

    public EventGroup(Object groupId, MuleContext muleContext) {
        this(groupId, muleContext, -1, DEFAULT_STORE_PREFIX);
    }

    public EventGroup(Object groupId, MuleContext muleContext, int expectedSize, String storePrefix) {
        this.muleContext = muleContext;
        this.storePrefix = storePrefix;
        this.eventsPartitionKey = storePrefix + ".eventGroups." + groupId;
        this.expectedSize = expectedSize;
        this.groupId = groupId;
    }

    @Override
    public int compareTo(EventGroup other) {
        Object otherId = other.getGroupId();
        if (this.groupId instanceof Comparable && otherId instanceof Comparable) {
            return ((Comparable)this.groupId).compareTo(otherId);
        }
        long diff = this.created - other.getCreated();
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventGroup)) {
            return false;
        }
        EventGroup other = (EventGroup)obj;
        if (this.groupId == null) {
            return other.groupId == null;
        }
        return this.groupId.equals(other.groupId);
    }

    public int hashCode() {
        return this.groupId.hashCode();
    }

    public Object getGroupId() {
        return this.groupId;
    }

    public Iterator<MuleEvent> iterator() throws ObjectStoreException {
        return this.iterator(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<MuleEvent> iterator(boolean sortByArrival) throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            if (this.eventsObjectStore.allKeys(this.eventsPartitionKey).isEmpty()) {
                return IteratorUtils.emptyIterator();
            }
            return IteratorUtils.arrayIterator((Object[])this.toArray(sortByArrival));
        }
    }

    public MuleEvent[] toArray() throws ObjectStoreException {
        return this.toArray(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent[] toArray(boolean sortByArrival) throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            if (this.eventsObjectStore.allKeys(this.eventsPartitionKey).isEmpty()) {
                return EMPTY_EVENTS_ARRAY;
            }
            return this.convertWrapperOrderEventCollectionToMuleEventArray(this.getWrapperEventsFromStore(sortByArrival));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<WrapperOrderEvent> getWrapperEventsFromStore(boolean orderByArrival) throws ObjectStoreException {
        AbstractCollection wrapperOrderEvents = orderByArrival ? new TreeSet<WrapperOrderEvent>(new TimeOrderEventComparator()) : new ArrayList();
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            for (Serializable key : this.eventsObjectStore.allKeys(this.eventsPartitionKey)) {
                wrapperOrderEvents.add((WrapperOrderEvent)this.eventsObjectStore.retrieve(key, this.eventsPartitionKey));
            }
        }
        return wrapperOrderEvents;
    }

    private MuleEvent[] convertWrapperOrderEventCollectionToMuleEventArray(Collection<WrapperOrderEvent> wrapperOrderEvents) {
        MuleEvent[] events = new MuleEvent[wrapperOrderEvents.size()];
        int i = 0;
        for (WrapperOrderEvent wrapperOrderEvent : wrapperOrderEvents) {
            events[i++] = wrapperOrderEvent.event;
        }
        return events;
    }

    private MuleMessageCollection convertWrapperOrderEventCollectionToMuleMessageCollection(Collection<WrapperOrderEvent> wrapperOrderEvents) {
        DefaultMessageCollection muleMessageCollection = new DefaultMessageCollection(this.muleContext);
        for (WrapperOrderEvent wrapperOrderEvent : wrapperOrderEvents) {
            muleMessageCollection.addMessage(wrapperOrderEvent.event.getMessage());
        }
        return muleMessageCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(MuleEvent event) throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            String key = this.getEventKey(event);
            this.lastStoredEventKey = key;
            this.eventsObjectStore.store((Serializable)((Object)key), new WrapperOrderEvent(event, System.nanoTime()), this.eventsPartitionKey);
            if (!hasNoCommonRootId) {
                String rootId = event.getMessage().getMessageRootId();
                if (this.commonRootId == null) {
                    this.commonRootId = rootId;
                } else if (!this.commonRootId.equals(rootId)) {
                    hasNoCommonRootId = true;
                    this.commonRootId = null;
                }
            }
        }
    }

    private String getEventKey(MuleEvent event) {
        return event.getId() + event.getMessage().getCorrelationSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent(MuleEvent event) throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            this.eventsObjectStore.remove((Serializable)((Object)event.getId()), this.eventsPartitionKey);
        }
    }

    public long getCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            try {
                return this.eventsObjectStore.allKeys(this.eventsPartitionKey).size();
            }
            catch (ObjectStoreException e) {
                return -1;
            }
        }
    }

    public int expectedSize() {
        return this.expectedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            this.eventsObjectStore.clear(this.eventsPartitionKey);
            this.eventsObjectStore.disposePartition(this.eventsPartitionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder(80);
        buf.append(ClassUtils.getSimpleName(this.getClass()));
        buf.append(" {");
        buf.append("id=").append(this.groupId);
        buf.append(", expected size=").append(this.expectedSize);
        try {
            EventGroup eventGroup = this;
            synchronized (eventGroup) {
                int currentSize = this.eventsObjectStore.allKeys(this.eventsPartitionKey).size();
                buf.append(", current events=").append(currentSize);
                if (currentSize > 0) {
                    buf.append(" [");
                    Iterator<Serializable> i = this.eventsObjectStore.allKeys(this.eventsPartitionKey).iterator();
                    while (i.hasNext()) {
                        Serializable id = i.next();
                        buf.append(this.eventsObjectStore.retrieve((Serializable)id, (String)this.eventsPartitionKey).event.getMessage().getUniqueId());
                        if (!i.hasNext()) continue;
                        buf.append(", ");
                    }
                    buf.append(']');
                }
            }
        }
        catch (ObjectStoreException e) {
            buf.append("ObjectStoreException " + e + " caught:" + e.getMessage());
        }
        buf.append('}');
        return buf.toString();
    }

    public MuleMessageCollection toMessageCollection() throws ObjectStoreException {
        return this.toMessageCollection(true);
    }

    public MuleMessageCollection toMessageCollection(boolean sortByArrival) throws ObjectStoreException {
        return this.convertWrapperOrderEventCollectionToMuleMessageCollection(this.getWrapperEventsFromStore(sortByArrival));
    }

    public String getCommonRootId() {
        return this.commonRootId;
    }

    public MuleEvent getMessageCollectionEvent() {
        try {
            if (this.size() > 0) {
                MuleEvent lastEvent = this.retrieveLastStoredEvent();
                DefaultMuleEvent muleEvent = new DefaultMuleEvent((MuleMessage)this.toMessageCollection(), lastEvent, this.getMergedSession());
                if (this.getCommonRootId() != null) {
                    muleEvent.getMessage().setMessageRootId(this.commonRootId);
                }
                return muleEvent;
            }
            return VoidMuleEvent.getInstance();
        }
        catch (ObjectStoreException e) {
            return VoidMuleEvent.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MuleEvent retrieveLastStoredEvent() throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            if (this.lastStoredEventKey == null) {
                this.lastStoredEventKey = this.findLastStoredEventKey();
            }
            return this.eventsObjectStore.retrieve((Serializable)this.lastStoredEventKey, (String)this.eventsPartitionKey).event;
        }
    }

    protected MuleSession getMergedSession() throws ObjectStoreException {
        MuleEvent lastStoredEvent = this.retrieveLastStoredEvent();
        DefaultMuleSession session = new DefaultMuleSession(lastStoredEvent.getSession());
        for (Serializable key : this.eventsObjectStore.allKeys(this.eventsPartitionKey)) {
            if (key.equals(this.lastStoredEventKey)) continue;
            this.addAndOverrideSessionProperties(session, this.eventsObjectStore.retrieve((Serializable)key, (String)this.eventsPartitionKey).event);
        }
        this.addAndOverrideSessionProperties(session, lastStoredEvent);
        return session;
    }

    private void addAndOverrideSessionProperties(MuleSession session, MuleEvent event) {
        for (String name : event.getSession().getPropertyNamesAsSet()) {
            session.setProperty(name, event.getSession().getProperty(name));
        }
    }

    public void initAfterDeserialisation(MuleContext context) throws MuleException {
        this.muleContext = context;
    }

    public void initEventsStore(PartitionableObjectStore<WrapperOrderEvent> events) throws ObjectStoreException {
        this.eventsObjectStore = events;
        events.open(this.eventsPartitionKey);
    }

    private String findLastStoredEventKey() throws ObjectStoreException {
        MuleEvent[] muleEvents = this.toArray(true);
        if (muleEvents.length > 0) {
            return this.getEventKey(muleEvents[muleEvents.length - 1]);
        }
        return null;
    }

    public boolean isInitialised() {
        return this.muleContext != null;
    }

    public final class TimeOrderEventComparator
    implements Comparator<WrapperOrderEvent> {
        @Override
        public int compare(WrapperOrderEvent wrapperOrderEvent1, WrapperOrderEvent wrapperOrderEvent2) {
            long time1 = wrapperOrderEvent1.timeOrder;
            long time2 = wrapperOrderEvent2.timeOrder;
            return time1 - time2 > 0L ? 1 : -1;
        }
    }
}

