/*
 * Decompiled with CFR 0.152.
 */
package org.mule.serialization.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.api.serialization.SerializationException;
import org.mule.util.IOUtils;
import org.mule.util.Preconditions;
import org.mule.util.store.DeserializationPostInitialisable;

public abstract class AbstractObjectSerializer
implements ObjectSerializer,
MuleContextAware {
    protected MuleContext muleContext;

    public AbstractObjectSerializer() {
    }

    AbstractObjectSerializer(ObjectSerializer other) {
        if (other instanceof AbstractObjectSerializer) {
            this.muleContext = ((AbstractObjectSerializer)other).muleContext;
        }
    }

    protected abstract byte[] doSerialize(Object var1) throws Exception;

    protected abstract <T> T doDeserialize(InputStream var1, ClassLoader var2) throws Exception;

    @Override
    public byte[] serialize(Object object) throws SerializationException {
        try {
            return this.doSerialize(object);
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize object", (Throwable)e);
        }
    }

    @Override
    public void serialize(Object object, OutputStream out) throws SerializationException {
        try {
            byte[] bytes = this.serialize(object);
            out.write(bytes);
            out.flush();
        }
        catch (IOException e) {
            throw new SerializationException("Could not write to output stream", (Throwable)e);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes) throws SerializationException {
        return this.deserialize(bytes, this.muleContext.getExecutionClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(byte[] bytes, ClassLoader classLoader) throws SerializationException {
        T t;
        Preconditions.checkArgument(bytes != null, "The byte[] must not be null");
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(bytes);
            t = this.deserialize(inputStream, classLoader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return t;
    }

    @Override
    public <T> T deserialize(InputStream inputStream) throws SerializationException {
        return this.deserialize(inputStream, this.muleContext.getExecutionClassLoader());
    }

    @Override
    public <T> T deserialize(InputStream inputStream, ClassLoader classLoader) throws SerializationException {
        Preconditions.checkArgument(inputStream != null, "Cannot deserialize a null stream");
        Preconditions.checkArgument(classLoader != null, "Cannot deserialize with a null classloader");
        try {
            return this.postInitialize(this.doDeserialize(inputStream, classLoader));
        }
        catch (Exception e) {
            throw new SerializationException("Could not deserialize object", (Throwable)e);
        }
    }

    protected <T> T postInitialize(T object) throws SerializationException {
        if (object instanceof DeserializationPostInitialisable) {
            try {
                DeserializationPostInitialisable.Implementation.init(object, this.muleContext);
            }
            catch (Exception e) {
                throw new SerializationException(String.format("Could not initialize instance of %s after deserialization", object.getClass().getName()), (Throwable)e);
            }
        }
        return object;
    }

    @Override
    public final void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

