/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.List;
import org.apache.commons.beanutils.MethodUtils;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;

public class TransformerWeighting
implements Comparable {
    private Transformer transformer;
    private int inputWeighting;
    private int outputWeighting;
    private Class inputClass;
    private Class outputClass;

    public TransformerWeighting(Class inputClass, Class outputClass, Transformer transformer) {
        this.inputClass = inputClass;
        this.outputClass = outputClass;
        this.transformer = transformer;
        this.init();
    }

    private void init() {
        this.inputWeighting = Integer.MAX_VALUE;
        List<DataType<?>> sourceTypes = this.transformer.getSourceDataTypes();
        for (DataType<?> type : sourceTypes) {
            int weighting = this.getWeighting(-1, this.inputClass, type.getType());
            if (weighting >= this.inputWeighting || weighting == -1) continue;
            this.inputWeighting = weighting;
        }
        this.outputWeighting = this.getWeighting(-1, this.outputClass, this.transformer.getReturnDataType().getType());
        this.inputWeighting = this.inputWeighting == Integer.MAX_VALUE ? -1 : this.inputWeighting;
        this.outputWeighting = this.outputWeighting == Integer.MAX_VALUE ? -1 : this.outputWeighting;
    }

    protected int getWeighting(int weighting, Class src, Class dest) {
        if (!dest.isAssignableFrom(src)) {
            if (src.isPrimitive()) {
                return this.getWeighting(weighting, MethodUtils.getPrimitiveWrapper((Class)src), dest);
            }
            return -1;
        }
        if (dest.equals(src)) {
            if (dest.equals(Object.class)) {
                return weighting + 3;
            }
            return weighting + 1;
        }
        if (dest.isInterface() && src.getInterfaces().length > 0) {
            for (int i = 0; i < src.getInterfaces().length; ++i) {
                Class<?> aClass = src.getInterfaces()[i];
                if (!dest.equals(aClass)) continue;
                return weighting + 2;
            }
        }
        if (src.getSuperclass() != null) {
            return this.getWeighting(weighting + 1, src.getSuperclass(), dest);
        }
        return -1;
    }

    public Class getInputClass() {
        return this.inputClass;
    }

    public int getInputWeighting() {
        return this.inputWeighting;
    }

    public Class getOutputClass() {
        return this.outputClass;
    }

    public int getOutputWeighting() {
        return this.outputWeighting;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public boolean isExactMatch() {
        return this.inputWeighting == 0 && this.outputWeighting == 0;
    }

    public boolean isNotMatch() {
        return this.inputWeighting == -1 || this.outputWeighting == -1;
    }

    public int compareTo(Object o) {
        TransformerWeighting weighting = (TransformerWeighting)o;
        if (weighting.getInputWeighting() == this.getInputWeighting() && weighting.getOutputWeighting() == this.getOutputWeighting()) {
            if (weighting.getTransformer() instanceof Converter && this.getTransformer() instanceof Converter) {
                int y;
                int x = ((Converter)weighting.getTransformer()).getPriorityWeighting();
                if (x > (y = ((Converter)this.getTransformer()).getPriorityWeighting())) {
                    return -1;
                }
                if (x < y) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
        if (!weighting.isNotMatch() && this.isNotMatch()) {
            return -1;
        }
        if (weighting.isNotMatch() && !this.isNotMatch()) {
            return 1;
        }
        if (weighting.isExactMatch() && !this.isExactMatch()) {
            return -1;
        }
        if (weighting.getInputWeighting() < this.getInputWeighting() && weighting.getOutputWeighting() < this.getOutputWeighting()) {
            return -1;
        }
        if (weighting.getInputWeighting() == this.getInputWeighting() && weighting.getOutputWeighting() < this.getOutputWeighting()) {
            return -1;
        }
        if (weighting.getInputWeighting() < this.getInputWeighting() && weighting.getOutputWeighting() == this.getOutputWeighting()) {
            return -1;
        }
        if (weighting.getInputWeighting() < this.getInputWeighting() && weighting.getOutputWeighting() > this.getOutputWeighting()) {
            return 1;
        }
        if (weighting.getInputWeighting() > this.getInputWeighting() && weighting.getOutputWeighting() < this.getOutputWeighting()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformerWeighting that = (TransformerWeighting)o;
        if (this.inputClass != null ? !this.inputClass.equals(that.inputClass) : that.inputClass != null) {
            return false;
        }
        return !(this.outputClass != null ? !this.outputClass.equals(that.outputClass) : that.outputClass != null);
    }

    public int hashCode() {
        int result = this.transformer != null ? this.transformer.hashCode() : 0;
        result = 31 * result + this.inputWeighting;
        result = 31 * result + this.outputWeighting;
        result = 31 * result + (this.inputClass != null ? this.inputClass.hashCode() : 0);
        result = 31 * result + (this.outputClass != null ? this.outputClass.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransformerWeighting");
        sb.append("{inputClass=").append(this.inputClass);
        sb.append(", inputWeighting=").append(this.inputWeighting);
        sb.append(", outputClass=").append(this.outputClass);
        sb.append(", outputWeighting=").append(this.outputWeighting);
        sb.append(", transformer=").append(this.transformer.getName());
        sb.append('}');
        return sb.toString();
    }
}

