/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.transformer.graph.TransformationEdge;
import org.mule.transformer.graph.TransformationGraph;

public class SynchronizedTransformationGraph {
    private ReentrantReadWriteLock readWriteLock;
    private TransformationGraph transformationGraph = new TransformationGraph();

    public SynchronizedTransformationGraph() {
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public void addConverter(Converter converter) {
        this.readWriteLock.writeLock().lock();
        try {
            this.transformationGraph.addConverter(converter);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void removeConverter(Converter converter) {
        this.readWriteLock.writeLock().lock();
        try {
            this.transformationGraph.removeConverter(converter);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public Set<TransformationEdge> outgoingEdgesOf(DataType<?> vertex) {
        this.readWriteLock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.transformationGraph.outgoingEdgesOf(vertex));
            return immutableSet;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public DataType<?> getEdgeTarget(TransformationEdge transformationEdge) {
        this.readWriteLock.readLock().lock();
        try {
            DataType dataType = (DataType)this.transformationGraph.getEdgeTarget(transformationEdge);
            return dataType;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public boolean containsVertex(DataType<?> dataType) {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.transformationGraph.containsVertex(dataType);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

