/*
 * Decompiled with CFR 0.152.
 */
package org.mule.work;

import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkAdapter;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RequestContext;
import org.mule.transaction.TransactionCoordination;
import org.mule.util.concurrent.Latch;

public class WorkerContext
implements Work {
    protected static final Log logger = LogFactory.getLog(WorkerContext.class);
    private static final WorkListener NULL_WORK_LISTENER = new WorkAdapter(){

        public void workRejected(WorkEvent event) {
            if (event.getException() != null) {
                this.logEventException(event.getWork().toString() + " Rejected", event.getException());
            }
        }

        public void workCompleted(WorkEvent event) {
            if (event.getException() != null) {
                this.logEventException(event.getWork().toString() + " Completed with exception", event.getException());
            }
        }

        private void logEventException(String message, WorkException exception) {
            if (exception instanceof WorkCompletedException && exception.getCause() != null) {
                logger.error((Object)message, exception.getCause());
            } else {
                logger.error((Object)message, (Throwable)exception);
            }
        }
    };
    protected ClassLoader executionClassLoader;
    private int threadPriority;
    private Work worker;
    private long acceptedTime;
    private int retryCount;
    private long startTimeOut;
    private final ExecutionContext executionContext;
    private WorkListener workListener = NULL_WORK_LISTENER;
    private WorkException workException;
    private final Latch startLatch = new Latch();
    private final Latch endLatch = new Latch();

    public WorkerContext(Work work) {
        this.executionClassLoader = Thread.currentThread().getContextClassLoader();
        this.worker = work;
        this.executionContext = null;
    }

    public WorkerContext(Work aWork, long aStartTimeout, ExecutionContext execContext, WorkListener workListener) {
        this.executionClassLoader = Thread.currentThread().getContextClassLoader();
        this.worker = aWork;
        this.startTimeOut = aStartTimeout;
        this.executionContext = execContext;
        if (null != workListener) {
            this.workListener = workListener;
        }
    }

    public void release() {
        this.worker.release();
    }

    public void setThreadPriority(int aPriority) {
        this.threadPriority = aPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public synchronized void workAccepted(Object anObject) {
        this.acceptedTime = System.currentTimeMillis();
        this.workListener.workAccepted(new WorkEvent(anObject, 1, this.worker, null));
    }

    public synchronized long getAcceptedTime() {
        return this.acceptedTime;
    }

    public long getStartTimeout() {
        return this.startTimeOut;
    }

    public synchronized boolean isTimedOut() {
        boolean isTimeout;
        if (0L == this.startTimeOut || this.startTimeOut == Long.MAX_VALUE) {
            return false;
        }
        boolean bl = isTimeout = this.acceptedTime + this.startTimeOut > 0L && System.currentTimeMillis() > this.acceptedTime + this.startTimeOut;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this + " accepted at " + this.acceptedTime + (isTimeout ? " has timed out." : " has not timed out. ") + this.retryCount + " retries have been performed."));
        }
        if (isTimeout) {
            this.workException = new WorkRejectedException(this + " has timed out.", "1");
            this.workListener.workRejected(new WorkEvent((Object)this, 2, this.worker, this.workException));
            return true;
        }
        ++this.retryCount;
        return isTimeout;
    }

    public synchronized WorkException getWorkException() {
        return this.workException;
    }

    public void run() {
        if (this.isTimedOut()) {
            this.startLatch.countDown();
            this.endLatch.countDown();
            return;
        }
        this.workListener.workStarted(new WorkEvent((Object)this, 3, this.worker, null));
        this.startLatch.countDown();
        try {
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.executionClassLoader);
                this.worker.run();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
            this.workListener.workCompleted(new WorkEvent((Object)this, 4, this.worker, null));
        }
        catch (Throwable e) {
            this.workException = (WorkException)(e instanceof WorkCompletedException ? e : new WorkCompletedException("Unknown error", "0").initCause(e));
            this.workListener.workCompleted(new WorkEvent((Object)this, 2, this.worker, this.workException));
        }
        finally {
            RequestContext.clear();
            TransactionCoordination.getInstance().clear();
            this.endLatch.countDown();
        }
    }

    public Latch provideStartLatch() {
        return this.startLatch;
    }

    public Latch provideEndLatch() {
        return this.endLatch;
    }

    public String toString() {
        return "Work: " + this.worker;
    }
}

