/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import java.io.IOException;
import java.util.Collection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResponseCompletionHandler
extends EmptyCompletionHandler<WriteResult> {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final FilterChainContext ctx;

    public BaseResponseCompletionHandler() {
        this.ctx = null;
    }

    protected BaseResponseCompletionHandler(FilterChainContext ctx) {
        this.ctx = ctx;
    }

    public void start() throws IOException {
        if (this.ctx.getFilterChain() == null) {
            this.logger.warn("Filter chain context already reset. Not sending response.");
            return;
        }
        this.doStart();
    }

    protected void doStart() throws IOException {
    }

    protected HttpResponsePacket buildHttpResponsePacket(HttpRequestPacket sourceRequest, HttpResponse httpResponse) {
        HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)sourceRequest).status(httpResponse.getStatusCode()).reasonPhrase(httpResponse.getReasonPhrase());
        Collection<String> allHeaders = httpResponse.getHeaderNames();
        for (String headerName : allHeaders) {
            Collection<String> values = httpResponse.getHeaderValues(headerName);
            for (String value : values) {
                responsePacketBuilder.header(headerName, value);
            }
        }
        HttpResponsePacket httpResponsePacket = responsePacketBuilder.build();
        httpResponsePacket.setProtocol(sourceRequest.getProtocol());
        if (httpResponse.getHeaderValueIgnoreCase("Transfer-Encoding") != null) {
            httpResponsePacket.setChunked(true);
        }
        if ("close".equalsIgnoreCase(httpResponsePacket.getHeader("Connection"))) {
            httpResponsePacket.getProcessingState().setKeepAlive(false);
        }
        return httpResponsePacket;
    }

    public void cancelled() {
        this.logger.warn("HTTP response sending task was cancelled");
    }

    public void failed(Throwable throwable) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(String.format("HTTP response sending task failed with error: %s", throwable.getMessage()));
        }
    }
}

