/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLSession;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpEvents;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.internal.domain.EmptyHttpEntity;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.OutputHandlerHttpEntity;
import org.mule.module.http.internal.domain.request.ClientConnection;
import org.mule.module.http.internal.domain.request.HttpRequestContext;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.domain.response.HttpResponseBuilder;
import org.mule.module.http.internal.listener.RequestHandlerProvider;
import org.mule.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.module.http.internal.listener.async.RequestHandler;
import org.mule.module.http.internal.listener.async.ResponseStatusCallback;
import org.mule.module.http.internal.listener.grizzly.GrizzlyHttpRequestAdapter;
import org.mule.module.http.internal.listener.grizzly.ResponseCompletionHandler;
import org.mule.module.http.internal.listener.grizzly.ResponseDeferringCompletionHandler;
import org.mule.module.http.internal.listener.grizzly.ResponseStreamingCompletionHandler;

public class GrizzlyRequestDispatcherFilter
extends BaseFilter {
    private final RequestHandlerProvider requestHandlerProvider;

    GrizzlyRequestDispatcherFilter(RequestHandlerProvider requestHandlerProvider) {
        this.requestHandlerProvider = requestHandlerProvider;
    }

    public NextAction handleRead(final FilterChainContext ctx) throws IOException {
        String scheme = ctx.getAttributes().getAttribute(HttpConstants.Protocols.HTTPS.getScheme()) == null ? HttpConstants.Protocols.HTTP.getScheme() : HttpConstants.Protocols.HTTPS.getScheme();
        String ip = ((InetSocketAddress)ctx.getConnection().getLocalAddress()).getAddress().getHostAddress();
        int port = ((InetSocketAddress)ctx.getConnection().getLocalAddress()).getPort();
        HttpContent httpContent = (HttpContent)ctx.getMessage();
        final HttpRequestPacket request = (HttpRequestPacket)httpContent.getHttpHeader();
        if (ctx.getConnection().getAttributes().getAttribute("__executor_rejected__") != null) {
            this.sendEmptyResponse(ctx, request, HttpConstants.HttpStatus.SERVICE_UNAVAILABLE);
            return ctx.getStopAction();
        }
        if (ctx.getConnection().getAttributes().getAttribute("__executor_discarded__") != null) {
            this.sendEmptyResponse(ctx, request, HttpConstants.HttpStatus.DROPPED);
            return ctx.getStopAction();
        }
        if (request.requiresAcknowledgement()) {
            HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)request);
            if ("100-continue".equalsIgnoreCase(request.getHeader("Expect"))) {
                responsePacketBuilder.status(HttpStatus.CONINTUE_100.getStatusCode());
                HttpResponsePacket packet = responsePacketBuilder.build();
                packet.setAcknowledgement(true);
                ctx.write((Object)packet);
                return ctx.getStopAction();
            }
            responsePacketBuilder.status(HttpStatus.EXPECTATION_FAILED_417.getStatusCode());
            ctx.write((Object)responsePacketBuilder.build());
            return ctx.getStopAction();
        }
        final GrizzlyHttpRequestAdapter httpRequest = new GrizzlyHttpRequestAdapter(ctx, httpContent);
        HttpRequestContext requestContext = this.createRequestContext(ctx, scheme, httpRequest);
        RequestHandler requestHandler = this.requestHandlerProvider.getRequestHandler(ip, port, httpRequest);
        requestHandler.handleRequest(requestContext, new HttpResponseReadyCallback(){

            @Override
            public void responseReady(HttpResponse httpResponse, ResponseStatusCallback responseStatusCallback) {
                try {
                    if (httpRequest.getMethod().equals(HttpConstants.Methods.HEAD.name())) {
                        if (httpResponse.getEntity() instanceof InputStreamHttpEntity) {
                            ((InputStreamHttpEntity)httpResponse.getEntity()).getInputStream().close();
                        }
                        httpResponse = new HttpResponseBuilder(httpResponse).setEntity(new EmptyHttpEntity()).build();
                    }
                    if (httpResponse.getEntity() instanceof InputStreamHttpEntity) {
                        new ResponseStreamingCompletionHandler(ctx, request, httpResponse, responseStatusCallback).start();
                    } else if (httpResponse.getEntity() instanceof OutputHandlerHttpEntity) {
                        new ResponseDeferringCompletionHandler(ctx, request, httpResponse, responseStatusCallback).start();
                    } else {
                        new ResponseCompletionHandler(ctx, request, httpResponse, responseStatusCallback).start();
                    }
                }
                catch (Exception e) {
                    responseStatusCallback.responseSendFailure(e);
                }
            }
        });
        return ctx.getSuspendAction();
    }

    private void sendEmptyResponse(FilterChainContext ctx, HttpRequestPacket request, HttpConstants.HttpStatus status) {
        HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)request);
        responsePacketBuilder.status(status.getStatusCode());
        HttpResponsePacket packet = responsePacketBuilder.build();
        packet.setContentLength(0);
        packet.setReasonPhrase(status.getReasonPhrase());
        ctx.write((Object)packet);
        ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
    }

    private HttpRequestContext createRequestContext(FilterChainContext ctx, String scheme, GrizzlyHttpRequestAdapter httpRequest) {
        SSLSession sslSession = (SSLSession)ctx.getAttributes().getAttribute("muleSslSession");
        ClientConnection clientConnection = sslSession != null ? new ClientConnection(sslSession, (InetSocketAddress)ctx.getConnection().getPeerAddress()) : new ClientConnection((InetSocketAddress)ctx.getConnection().getPeerAddress());
        return new HttpRequestContext(httpRequest, clientConnection, scheme);
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        HttpHeader header;
        if (event.type() == HttpEvents.IncomingHttpUpgradeEvent.TYPE && (header = ((HttpEvents.IncomingHttpUpgradeEvent)event).getHttpHeader()).isRequest()) {
            header.setIgnoreContentModifiers(false);
            return ctx.getStopAction();
        }
        if (event.type() == HttpEvents.OutgoingHttpUpgradeEvent.TYPE) {
            HttpEvents.OutgoingHttpUpgradeEvent outUpgradeEvent = (HttpEvents.OutgoingHttpUpgradeEvent)event;
            outUpgradeEvent.getHttpHeader().setIgnoreContentModifiers(false);
            return ctx.getStopAction();
        }
        return super.handleEvent(ctx, event);
    }
}

