/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.params;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.mule.runtime.params.ConfigFileUtils;
import org.mule.runtime.params.SequenceInfo;

public class WrapperAdditionalRefresher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        File wrapperConfigFile = new File(args[0]);
        File wrapperAdditionalConfFile = ConfigFileUtils.getFileInSameDir(wrapperConfigFile, "wrapper-additional.conf");
        File updatedWrapperAdditionalConfFile = ConfigFileUtils.getFileInSameDir(wrapperConfigFile, "wrapper-additional-tmp.conf");
        SequenceInfo sequenceInfo = ConfigFileUtils.lookupLastSequencesFromConfig(wrapperConfigFile);
        try {
            WrapperAdditionalRefresher.copyUpdatingSequences(wrapperAdditionalConfFile, updatedWrapperAdditionalConfFile, sequenceInfo);
            Files.move(updatedWrapperAdditionalConfFile.toPath(), wrapperAdditionalConfFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(updatedWrapperAdditionalConfFile.toPath());
        }
    }

    private static void copyUpdatingSequences(File srcConfFile, File dstConfFile, SequenceInfo sequenceInfo) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(srcConfFile));
             BufferedWriter writer = new BufferedWriter(new FileWriter(dstConfFile));){
            Iterable lines = reader.lines()::iterator;
            for (String line : lines) {
                writer.write(sequenceInfo.reSequenceLine(line));
                writer.newLine();
            }
        }
    }
}

