/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.dsl.util;

import java.io.InputStream;
import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.tools.ResourceUtils;
import org.mule.config.dsl.IOException;
import org.mule.config.dsl.util.Preconditions;
import org.mule.util.IOUtils;

public class ClasspathBuilder {
    private final String path;
    private InputStream content = null;
    private String stringContent = null;

    public ClasspathBuilder(String path) throws IllegalArgumentException {
        this.path = Preconditions.checkNotEmpty(path, "path");
    }

    public InputStream get() throws IOException {
        if (this.content == null) {
            Resource res = ResourceUtils.getResource(this.getClass(), (String)this.path, null);
            if (res == null) {
                throw new IOException("Resource not found.");
            }
            this.content = res.getResourceAsStream();
        }
        return this.content;
    }

    public String getAsString() throws IOException {
        if (this.stringContent == null) {
            this.stringContent = IOUtils.toString((InputStream)this.get());
        }
        return this.stringContent;
    }
}

