/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.dsl.example.email;

import java.util.HashMap;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import org.mule.api.MuleException;
import org.mule.config.dsl.AbstractModule;
import org.mule.config.dsl.FlowBuilder;
import org.mule.config.dsl.Module;
import org.mule.config.dsl.Mule;
import org.mule.transport.email.GmailSmtpConnector;

public class SendEmailUsingGMail {
    private static final String GMAIL_AUTH_USER = "your_user_name_here@gmail.com";
    private static final String GMAIL_AUTH_PWD = "your_password_here";
    private static final String SEND_MAIL_TO = "me@example.com";

    public static void main(String ... args) throws MuleException {
        Mule myMule = Mule.newInstance((Module[])new Module[]{new MyGmailModule()});
        myMule.start();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("subject", "Look this new Mule cool feature!");
        properties.put("address", SEND_MAIL_TO);
        String mailContent = "Email content here";
        myMule.flow("SendEmail").process((Object)"Email content here", properties);
    }

    public static class SMTPAuthenticator
    extends Authenticator {
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(SendEmailUsingGMail.GMAIL_AUTH_USER, SendEmailUsingGMail.GMAIL_AUTH_PWD);
        }
    }

    public static class MyGmailModule
    extends AbstractModule {
        protected void configure() {
            GmailSmtpConnector gmail = new GmailSmtpConnector(null);
            gmail.setAuthenticator((Authenticator)new SMTPAuthenticator());
            this.register("GmailConnector", gmail);
            ((FlowBuilder)this.flow("SendEmail").filterBy(String.class)).send("smtp://smtp.gmail.com?address=#[header:address]");
        }
    }
}

