/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.dsl.example.email.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.auth.EasyAuthenticationHandlerFactory;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.server.SMTPServer;

public class EmbeddedMailServer {
    static SMTPServer smtpServer = null;

    public static void start(int port) throws RuntimeException {
        if (smtpServer != null) {
            throw new RuntimeException("Server already started.");
        }
        smtpServer = new SMTPServer((MessageHandlerFactory)new MyMessageHandlerFactory());
        smtpServer.setAuthenticationHandlerFactory((AuthenticationHandlerFactory)new EasyAuthenticationHandlerFactory(new UsernamePasswordValidator(){

            public void login(String username, String password) throws LoginFailedException {
                if (!username.equals("user1") || !password.equals("secret")) {
                    throw new LoginFailedException();
                }
            }
        }));
        smtpServer.setPort(port);
        smtpServer.start();
    }

    public static void stop() {
        if (smtpServer != null) {
            smtpServer.stop();
            smtpServer = null;
        }
    }

    public static class MyMessageHandlerFactory
    implements MessageHandlerFactory {
        public MessageHandler create(MessageContext ctx) {
            return new Handler();
        }

        class Handler
        implements MessageHandler {
            Handler() {
            }

            public void from(String from) throws RejectException {
                System.out.println("FROM:" + from);
            }

            public void recipient(String recipient) throws RejectException {
                System.out.println("RECIPIENT:" + recipient);
            }

            public void data(InputStream data) throws IOException {
                System.out.println("MAIL DATA");
                System.out.println("= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =");
                System.out.println(this.convertStreamToString(data));
                System.out.println("= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =");
            }

            public synchronized void done() {
            }

            private String convertStreamToString(InputStream is) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder sb = new StringBuilder();
                String line = null;
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return sb.toString();
            }
        }
    }
}

