/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.dsl.example.http.support;

import com.google.inject.name.Named;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Random;
import org.mule.config.dsl.example.http.model.Person;

public class QueryData {
    private final Person[] persons = new Person[]{new Person("John", 20), new Person("Helen of Troy", 28), new Person("Bilbo Baggins", 80), new Person("Princess Leia", 22), new Person("Chewbacca", 35), new Person("Alexsander, the Great", 30)};
    private final Random random = new Random();

    @Named(value="randomData")
    public Object randomData() {
        return this.persons[this.random.nextInt(this.persons.length)];
    }

    @MethodGetPerson
    public Object getPerson(Map<String, Object> payload) {
        if (payload.containsKey("id")) {
            try {
                int id = Integer.valueOf(payload.get("id").toString());
                if (id >= this.persons.length) {
                    return "ID '" + id + "' not found!";
                }
                return this.persons[id];
            }
            catch (NumberFormatException ex) {
                return "ERR: ID param must be an integer!";
            }
        }
        return "ERR: Param ID must be provided!";
    }

    public String error() {
        return "ERROR!";
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MethodGetPerson {
    }
}

