/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.platform;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.gradle.api.Project;
import org.mule.dx.platform.ArtifactDependency;

public class DependencyHandlerExtension {
    private static final String PROPERTIES_FILE = "versions.properties";
    private final Project project;
    private ArtifactDependency muleDxApi;
    private ArtifactDependency pf4j;
    private ArtifactDependency pf4jAnnotationProcessor;
    private ArtifactDependency guice;
    private ArtifactDependency supportedLSP4JArtifact;
    private ArtifactDependency configuredLSP4j;
    private ArtifactDependency supportedLSP4JDebugArtifact;
    private ArtifactDependency configuredLSP4jDebug;

    public DependencyHandlerExtension(Project project) {
        this.project = project;
        this.setupArtifacts();
    }

    private void setupArtifacts() {
        try (InputStream versionProperties = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
            Properties prop = this.loadProperties(versionProperties);
            this.supportedLSP4JArtifact = new ArtifactDependency(prop.getProperty("lsp4j"));
            this.supportedLSP4JDebugArtifact = new ArtifactDependency(prop.getProperty("lsp4jDebug"));
            this.muleDxApi = new ArtifactDependency(prop.getProperty("muleDXApi"));
            this.pf4j = new ArtifactDependency(prop.getProperty("pf4j"));
            this.pf4jAnnotationProcessor = new ArtifactDependency(prop.getProperty("pf4jAPT"));
            this.guice = new ArtifactDependency(prop.getProperty("guice"));
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to read %s.", PROPERTIES_FILE), e);
        }
    }

    private Properties loadProperties(InputStream versionProperties) throws IOException {
        Properties prop = new Properties();
        prop.load(versionProperties);
        this.validate(prop);
        return prop;
    }

    private void validate(Properties prop) {
        this.validateEntry(prop, "lsp4j");
        this.validateEntry(prop, "muleDXApi");
        this.validateEntry(prop, "pf4j");
        this.validateEntry(prop, "guice");
    }

    private void validateEntry(Properties prop, String propertyKey) {
        String propertyValue = prop.getProperty(propertyKey);
        Objects.requireNonNull(propertyValue, propertyKey + " must be specified in versions.properties");
        String[] values = propertyValue.split(":");
        if (values.length != 4) {
            throw new IllegalArgumentException(String.format("The expected format should be groupId:artifactId:version:scope. [%s] does not match the expected format.", propertyValue));
        }
    }

    public void muleDXApiVersion(String version) {
        this.muleDxApi = this.muleDxApi.version(version);
    }

    public void pf4jVersion(String version) {
        this.pf4j = this.pf4j.version(version);
        this.pf4jAnnotationProcessor = this.pf4jAnnotationProcessor.version(version);
    }

    public void guice(String version) {
        this.guice = this.guice.version(version);
    }

    public void lsp4j() {
        this.configuredLSP4j = this.supportedLSP4JArtifact;
    }

    public void lsp4j(String version) {
        this.configuredLSP4j = this.supportedLSP4JArtifact.version(version);
    }

    public void lsp4jDebug() {
        this.configuredLSP4jDebug = this.supportedLSP4JDebugArtifact;
    }

    public void lsp4jDebug(String version) {
        this.configuredLSP4jDebug = this.supportedLSP4JDebugArtifact.version(version);
    }

    public void apply() {
        this.muleDxApi.applyTo(this.project);
        this.pf4j.applyTo(this.project);
        this.pf4jAnnotationProcessor.applyTo(this.project);
        this.guice.applyTo(this.project);
        if (this.configuredLSP4j != null) {
            this.configuredLSP4j.applyTo(this.project);
        }
        if (this.configuredLSP4jDebug != null) {
            this.configuredLSP4jDebug.applyTo(this.project);
        }
    }
}

