/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.platform;

import groovy.lang.Closure;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.util.Configurable;
import org.gradle.util.ConfigureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleDXManifestExtension
implements Configurable<MuleDXManifestExtension> {
    private static final Logger logger = LoggerFactory.getLogger(MuleDXManifestExtension.class);
    private String id;
    private String description;
    private String pluginClass;
    private String version;
    private String providerId;
    private List<String> dependencies;
    private List<String> requires;
    private String license;
    private Project project;

    public MuleDXManifestExtension(Project project) {
        this.project = project;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public void setPluginClass(String pluginClass) {
        this.pluginClass = pluginClass;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public void setRequires(List<String> requires) {
        this.requires = requires;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    private Map<String, String> toMap() {
        Objects.requireNonNull(this.id);
        String projectVersion = this.project.getVersion().toString();
        String actualVersion = this.isNotBlank(this.version) ? this.version : projectVersion;
        Objects.requireNonNull(actualVersion, "The project must have a version or version attribute needs to configured.");
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("Plugin-Id", this.id);
        if (this.isNotBlank(this.pluginClass)) {
            attributes.put("Plugin-Class", this.pluginClass);
        }
        attributes.put("Plugin-Version", actualVersion);
        if (this.isNotBlank(this.project.getDescription())) {
            attributes.put("Plugin-Description", this.project.getDescription());
        }
        if (this.isNotBlank(this.providerId)) {
            attributes.put("Plugin-Provider", this.providerId);
        }
        if (this.isNotBlank(this.license)) {
            attributes.put("Plugin-License", this.license);
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            attributes.put("Plugin-Dependencies", this.dependencies.stream().collect(Collectors.joining(",")));
        }
        if (this.requires != null && !this.requires.isEmpty()) {
            attributes.put("Plugin-Requires", this.requires.stream().collect(Collectors.joining(",")));
        }
        return attributes;
    }

    private boolean isNotBlank(String value) {
        return value != null && value.trim().length() > 0;
    }

    public String toString() {
        return "PluginManifestExtension{pluginId='" + this.id + "', description='" + this.description + "', pluginClass='" + this.pluginClass + "', version='" + this.version + "', providerId='" + this.providerId + "', dependencies='" + this.dependencies + "', requires='" + this.requires + "', license='" + this.license + "'}";
    }

    public MuleDXManifestExtension configure(Closure closure) {
        return (MuleDXManifestExtension)ConfigureUtil.configureSelf((Closure)closure, (Object)this);
    }

    public void apply() {
        Jar task = (Jar)this.project.getTasks().getByName("jar");
        if (task != null) {
            task.manifest(mf -> {
                Map<String, String> actualAttributes = this.toMap();
                logger.debug(String.format("Configuring manifest with attributes: %s", actualAttributes));
                mf.attributes(actualAttributes);
            });
        } else {
            logger.warn("No Jar task found for project. MANIFEST.MF will not automatically configure PF4J information.");
        }
    }
}

