/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.platform;

import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvableDependencies;

public class ArtifactDependency {
    private static final String DELIMITER = ":";
    private final String artifactId;
    private final String groupId;
    private final String version;
    private final String configurationName;

    public ArtifactDependency(String groupId, String artifactId, String version, String configurationName) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.configurationName = configurationName;
    }

    public ArtifactDependency(String gavAndScope) {
        String[] values = gavAndScope.split(DELIMITER);
        this.groupId = values[0];
        this.artifactId = values[1];
        this.version = values[2];
        this.configurationName = values[3];
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public ArtifactDependency version(String version) {
        return new ArtifactDependency(this.getGroupId(), this.getArtifactId(), version, this.getConfigurationName());
    }

    public boolean isContainedBy(Project project) {
        return !project.getConfigurations().getByName(this.configurationName).getDependencies().matching(dep -> dep.getName().equals(this.artifactId) && dep.getGroup().equals(this.groupId)).isEmpty();
    }

    public boolean matchesExactlyContainedBy(Project project) {
        return !project.getConfigurations().getByName(this.configurationName).getDependencies().matching(dep -> dep.getName().equals(this.artifactId) && dep.getGroup().equals(this.groupId) && dep.getVersion().equals(this.version)).isEmpty();
    }

    public void applyTo(final Project project) {
        final DependencySet dependencySet = project.getConfigurations().getByName(this.configurationName).getDependencies();
        project.getGradle().addListener((Object)new DependencyResolutionListener(){

            public void beforeResolve(ResolvableDependencies resolvableDependencies) {
                if (!ArtifactDependency.this.isContainedBy(project)) {
                    dependencySet.add((Object)project.getDependencies().create((Object)ArtifactDependency.this.toGAV()));
                }
                project.getGradle().removeListener((Object)this);
            }

            public void afterResolve(ResolvableDependencies resolvableDependencies) {
            }
        });
    }

    public String toGAV() {
        return String.join((CharSequence)DELIMITER, this.groupId, this.artifactId, this.version);
    }
}

