/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.math;

import org.mule.weave.v2.exception.InvalidNumberExpressionException;
import org.mule.weave.v2.model.values.math.BigDecimalNumber;
import org.mule.weave.v2.model.values.math.BigIntNumber;
import org.mule.weave.v2.model.values.math.LongNumber;
import org.mule.weave.v2.model.values.math.Number;
import scala.Double$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;

public final class Number$ {
    public static Number$ MODULE$;
    private final BigDecimal minDouble;
    private final BigDecimal maxDouble;
    private final int OK;
    private final int OVERFLOW;
    private final int INVALID_DATA;

    static {
        new Number$();
    }

    public BigDecimal minDouble() {
        return this.minDouble;
    }

    public BigDecimal maxDouble() {
        return this.maxDouble;
    }

    public int OK() {
        return this.OK;
    }

    public int OVERFLOW() {
        return this.OVERFLOW;
    }

    public int INVALID_DATA() {
        return this.INVALID_DATA;
    }

    public Number apply(String n) {
        Number number;
        Number.ParsingResult result = this.parseLong(n);
        if (result.resultType() == this.OK()) {
            number = new LongNumber(((Number)result.number().get()).toLong());
        } else {
            try {
                number = new BigIntNumber(package$.MODULE$.BigInt().apply(n));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    number = new BigDecimalNumber(package$.MODULE$.BigDecimal().apply(n));
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new InvalidNumberExpressionException(n, numberFormatException2.getMessage());
                }
            }
        }
        return number;
    }

    public Number apply(int n) {
        return new LongNumber(n);
    }

    public Number apply(long n) {
        return new LongNumber(n);
    }

    public Number apply(double n) {
        return new BigDecimalNumber(package$.MODULE$.BigDecimal().apply(n));
    }

    public Number apply(BigInt n) {
        return new BigIntNumber(n);
    }

    public Number apply(BigDecimal n) {
        return new BigDecimalNumber(n);
    }

    public Number.ParsingResult parseLong(String strNumber) {
        long num = 0L;
        int sign = -1;
        int len = strNumber.length();
        char ch = strNumber.charAt(0);
        if (ch == '-') {
            if (len == 1) {
                return new Number.ParsingResult((Option<Number>)None$.MODULE$, this.INVALID_DATA());
            }
            sign = 1;
        } else {
            int d = ch - 48;
            if (d < 0 || d > 9) {
                return new Number.ParsingResult((Option<Number>)None$.MODULE$, this.INVALID_DATA());
            }
            num = -d;
        }
        long max = sign == -1 ? -Long.MAX_VALUE : Long.MIN_VALUE;
        long multmax = max / 10L;
        int i = 1;
        while (i < len) {
            int d = strNumber.charAt(i) - 48;
            ++i;
            if (d < 0 || d > 9) {
                return new Number.ParsingResult((Option<Number>)None$.MODULE$, this.INVALID_DATA());
            }
            if (num < multmax) {
                return new Number.ParsingResult((Option<Number>)None$.MODULE$, this.OVERFLOW());
            }
            if ((num *= 10L) < max + (long)d) {
                return new Number.ParsingResult((Option<Number>)None$.MODULE$, this.OVERFLOW());
            }
            num -= (long)d;
        }
        return new Number.ParsingResult((Option<Number>)new Some((Object)this.apply((long)sign * num)), this.OK());
    }

    private Number$() {
        MODULE$ = this;
        this.minDouble = package$.MODULE$.BigDecimal().apply(Double$.MODULE$.MinValue());
        this.maxDouble = package$.MODULE$.BigDecimal().apply(Double.MAX_VALUE);
        this.OK = 0;
        this.OVERFLOW = 1;
        this.INVALID_DATA = 2;
    }
}

