/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.schema.tools;

import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.yaml.snakeyaml.1.15.shade.DumperOptions;
import org.yaml.snakeyaml.1.15.shade.Yaml;
import org.yaml.snakeyaml.1.15.shade.constructor.AbstractConstruct;
import org.yaml.snakeyaml.1.15.shade.constructor.Constructor;
import org.yaml.snakeyaml.1.15.shade.nodes.Node;
import org.yaml.snakeyaml.1.15.shade.nodes.ScalarNode;
import org.yaml.snakeyaml.1.15.shade.nodes.Tag;
import org.yaml.snakeyaml.1.15.shade.representer.Represent;
import org.yaml.snakeyaml.1.15.shade.representer.Representer;

public class YamlSupport {
    public static void writeMap(Map<String, Object> map, Writer writer) {
        Yaml yaml = new Yaml(new EdiRepresenter(), new DumperOptions());
        yaml.dump(map, writer);
    }

    public static Map<String, Object> readMap(String text) {
        Yaml yaml = new Yaml(new EdiConstructor());
        return (Map)yaml.load(new StringReader(text));
    }

    private static class EdiConstructor
    extends Constructor {
        public EdiConstructor() {
            this.yamlConstructors.put(new Tag("!bigdecimal"), new ConstructBigDecimal());
            this.yamlConstructors.put(new Tag("!biginteger"), new ConstructBigInteger());
        }

        private class ConstructBigInteger
        extends AbstractConstruct {
            private ConstructBigInteger() {
            }

            @Override
            public Object construct(Node node) {
                String value = (String)EdiConstructor.this.constructScalar((ScalarNode)node);
                return new BigInteger(value);
            }
        }

        private class ConstructBigDecimal
        extends AbstractConstruct {
            private ConstructBigDecimal() {
            }

            @Override
            public Object construct(Node node) {
                String value = (String)EdiConstructor.this.constructScalar((ScalarNode)node);
                return new BigDecimal(value);
            }
        }
    }

    private static class EdiRepresenter
    extends Representer {
        public EdiRepresenter() {
            this.representers.put(BigDecimal.class, new RepresentBigDecimal());
            this.representers.put(BigInteger.class, new RepresentBigInteger());
        }

        private class RepresentBigInteger
        implements Represent {
            private RepresentBigInteger() {
            }

            @Override
            public Node representData(Object value) {
                return EdiRepresenter.this.representScalar(new Tag("!biginteger"), ((BigInteger)value).toString());
            }
        }

        private class RepresentBigDecimal
        implements Represent {
            private RepresentBigDecimal() {
            }

            @Override
            public Node representData(Object value) {
                return EdiRepresenter.this.representScalar(new Tag("!bigdecimal"), ((BigDecimal)value).toString());
            }
        }
    }
}

