/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.EdifactConstants;
import com.anypoint.df.edi.lexical.WriterBase;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;

public class EdifactWriter
extends WriterBase {
    private final boolean needUna;
    private final String overrideDelimiters;

    public EdifactWriter(OutputStream os, Charset encoding, EdifactConstants.SyntaxVersion version, EdifactConstants.SyntaxIdentifier syntax, boolean enforce, String delims, String segsep, int subst, char mark) {
        super(os, EdifactWriter.encodingOrDefault(encoding, syntax), EdifactWriter.delimsOrDefault(delims, version, syntax).charAt(0), EdifactWriter.delimsOrDefault(delims, version, syntax).charAt(1), -1, EdifactConstants.charNonBlank(EdifactWriter.delimsOrDefault(delims, version, syntax).charAt(2)), EdifactWriter.delimsOrDefault(delims, version, syntax).charAt(3), segsep, EdifactConstants.charNonBlank(EdifactWriter.delimsOrDefault(delims, version, syntax).charAt(4)), subst, mark, enforce ? syntax.flags() : null);
        String dfltdelims = version.defaultDelimiters(syntax);
        this.needUna = delims != null && !delims.equals(dfltdelims);
        this.overrideDelimiters = delims;
    }

    private static Charset encodingOrDefault(Charset encoding, EdifactConstants.SyntaxIdentifier syntax) {
        if (encoding != null) {
            return encoding;
        }
        return syntax.defaultCharSet();
    }

    private static String delimsOrDefault(String delims, EdifactConstants.SyntaxVersion version, EdifactConstants.SyntaxIdentifier syntax) {
        if (delims != null) {
            return delims;
        }
        return version.defaultDelimiters(syntax);
    }

    @Override
    public void init(Map<String, Object> props) throws IOException {
        if (this.needUna || Boolean.TRUE.equals(props.get("forceUNA"))) {
            this.writer.write("UNA");
            this.writer.write(this.overrideDelimiters.charAt(1));
            this.writer.write(this.overrideDelimiters.charAt(0));
            this.writer.write(this.decimalMark);
            this.writer.write(this.overrideDelimiters.charAt(4));
            this.writer.write(this.overrideDelimiters.charAt(2));
            this.writer.write(this.overrideDelimiters.charAt(3));
            if (this.segmentSeparator != null) {
                this.writer.write(this.segmentSeparator);
            }
        }
        this.groupCount = 0;
    }

    @Override
    public void term(Map<String, Object> props) throws IOException {
    }
}

