/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class FlatFileLexer
extends LexerBase {
    private final LineBasedReader typedReader;
    private final Charset encoding;
    private final boolean allowRaw;
    private final boolean terminatedLines;
    private final boolean allowLong;
    private final boolean allowShort;
    private final int missingChar;
    private Boolean supportsRaw;
    private byte[] rawTransform;

    public FlatFileLexer(InputStream is, Charset enc, boolean raw, boolean terminated, boolean longOk, boolean shortOk, int miss) {
        super(is, -1);
        this.encoding = enc;
        this.allowRaw = raw;
        this.terminatedLines = terminated;
        this.allowLong = longOk;
        this.allowShort = shortOk;
        this.missingChar = miss;
        this.typedReader = new LineBasedReader(this.stream, enc);
        this.reader = this.typedReader;
    }

    @Override
    public void discardTo(EdiConstants.ItemType typ) throws IOException {
        if (typ != EdiConstants.ItemType.SEGMENT) {
            throw new IllegalArgumentException("Flat files do not support " + (Object)((Object)typ) + " data type positioning");
        }
        this.typedReader.nextLine(true);
    }

    public boolean nextLine() throws IOException {
        return this.typedReader.nextLine(this.allowLong);
    }

    public String loadTagField(int start, int length) throws IOException {
        return this.typedReader.loadTagField(start, length);
    }

    public void init() throws IOException {
        int chr = this.reader.read();
        if (chr >= 0) {
            this.typedReader.startLine(chr);
        } else {
            this.currentType = EdiConstants.ItemType.END;
        }
    }

    public boolean load(int width) throws IOException {
        this.tokenBuilder.setLength(0);
        boolean result = this.typedReader.readToken(width);
        this.currentType = EdiConstants.ItemType.DATA_ELEMENT;
        return result;
    }

    public byte[] rawToken() throws IOException {
        if (!this.allowRaw) {
            throw new IllegalStateException("Lexer is not configured for raw data access");
        }
        if (this.supportsRaw == null) {
            CharBuffer cbuf = CharBuffer.allocate(256);
            for (int i = 0; i < 256; ++i) {
                cbuf.put((char)i);
            }
            cbuf.position(0);
            ByteBuffer bbuf = this.encoding.encode(cbuf);
            char[] rchars = this.encoding.decode(bbuf).array();
            this.supportsRaw = Boolean.FALSE;
            if (rchars.length == 256) {
                this.supportsRaw = Boolean.TRUE;
                for (int i = 0; i < 256; ++i) {
                    if (rchars[i] == i) continue;
                    this.supportsRaw = Boolean.FALSE;
                    break;
                }
                this.rawTransform = bbuf.array();
            }
        }
        if (this.supportsRaw.booleanValue()) {
            String token2 = this.token();
            byte[] bytes = new byte[token2.length()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = this.rawTransform[token2.charAt(i)];
            }
            return bytes;
        }
        throw new IllegalStateException("Raw data is not supported for character encoding " + this.encoding.name());
    }

    public boolean atEnd() {
        return this.typedReader.lineEnd;
    }

    @Override
    public void error(TypeFormat typ, ErrorHandler.ErrorCondition err, String explain) throws LexicalException {
        boolean abort = false;
        String position = "element " + Integer.toString(this.elementNumber + 1);
        String text = err.text() + " for data type " + typ.typeCode() + " at " + position + ": '" + this.tokenBuilder + "'";
        if (explain != null) {
            text = text + " (" + explain + ")";
        }
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err, text);
            }
            this.errorHandler.error(typ, err, explain);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                this.logger.error("Unrecoverable lexer error " + text);
            } else {
                this.logger.info("Recoverable lexer error " + text);
            }
        }
    }

    private class LineBasedReader
    extends FilterReader {
        private boolean lineEnd;
        private int leadCount;
        private int leadOffset;
        private char[] leadBuffer;

        protected LineBasedReader(InputStream in, Charset enc) {
            super(new BufferedReader(new InputStreamReader(FlatFileLexer.this.stream, enc)));
            this.leadBuffer = new char[128];
            this.leadCount = 0;
        }

        protected String loadTagField(int start, int length) throws IOException {
            int limit = start + length;
            if (this.leadBuffer.length < limit) {
                char[] newbuff = new char[limit];
                System.arraycopy(this.leadBuffer, 0, newbuff, 0, this.leadCount);
                this.leadBuffer = newbuff;
            }
            int actual = 0;
            for (int remain = limit - this.leadCount; remain > 0 && (actual = super.read(this.leadBuffer, this.leadCount, remain)) > 0; remain -= actual) {
                this.leadCount += actual;
            }
            if (actual < 0) {
                throw new EOFException("read only " + this.leadCount + " with at least " + limit + " expected");
            }
            return new String(this.leadBuffer, start, length);
        }

        protected void startLine(int chr) {
            this.lineEnd = false;
            this.leadBuffer[0] = (char)chr;
            this.leadCount = 1;
            this.leadOffset = 0;
            ++FlatFileLexer.this.segmentNumber;
            FlatFileLexer.this.elementNumber = 0;
            FlatFileLexer.this.currentType = EdiConstants.ItemType.SEGMENT;
        }

        protected boolean nextLine(boolean force) throws IOException {
            int chr = 10;
            if (!this.lineEnd) {
                while ((chr = this.read()) != -1 && force && (!FlatFileLexer.this.terminatedLines || chr != 10 && chr != 13)) {
                }
            }
            if (chr == -1) {
                FlatFileLexer.this.currentType = EdiConstants.ItemType.END;
                return false;
            }
            if (FlatFileLexer.this.terminatedLines) {
                if (chr != 10 && chr != 13) {
                    throw new LexicalException("Missing expected line break after line " + FlatFileLexer.this.segmentNumber);
                }
                while ((chr = FlatFileLexer.this.reader.read()) == 10 || chr == 13) {
                }
            }
            if (chr == -1) {
                FlatFileLexer.this.currentType = EdiConstants.ItemType.END;
                return false;
            }
            this.startLine(chr);
            return true;
        }

        protected boolean readToken(int length) throws IOException {
            if (this.lineEnd) {
                return false;
            }
            boolean hasData = false;
            for (int i = 0; i < length; ++i) {
                int chr = this.read();
                if (chr == -1) {
                    if (FlatFileLexer.this.allowShort && FlatFileLexer.this.tokenBuilder.length() == 0) {
                        this.lineEnd = true;
                        break;
                    }
                    throw new LexicalException("Unexpected end of file in line " + FlatFileLexer.this.segmentNumber + " (read " + i + " of expected " + length + " characters in field)");
                }
                if (!FlatFileLexer.this.allowRaw && FlatFileLexer.this.terminatedLines && (chr == 13 || chr == 10)) {
                    if (FlatFileLexer.this.allowShort && FlatFileLexer.this.tokenBuilder.length() == 0) {
                        this.lineEnd = true;
                        break;
                    }
                    throw new LexicalException("Unexpected end of line" + FlatFileLexer.this.segmentNumber + " (read " + i + " of expected " + length + " characters in field)");
                }
                if (chr != FlatFileLexer.this.missingChar) {
                    hasData = true;
                }
                FlatFileLexer.this.tokenBuilder.append((char)chr);
            }
            ++FlatFileLexer.this.elementNumber;
            return hasData;
        }

        @Override
        public int read() throws IOException {
            if (this.leadOffset < this.leadCount) {
                return this.leadBuffer[this.leadOffset++];
            }
            return super.read();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int actual = 0;
            int remain = len;
            if (this.leadOffset < this.leadCount) {
                int use = Math.min(len, this.leadCount - this.leadOffset);
                System.arraycopy(this.leadBuffer, this.leadOffset, cbuf, off, use);
                this.leadOffset += use;
                actual = use;
                remain -= use;
            }
            if (remain > 0) {
                return actual + super.read(cbuf, off + actual, remain);
            }
            return actual;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            throw new UnsupportedOperationException("mark() is not supported");
        }
    }
}

