/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.schema.tools;

import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.Structure;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Map;
import org.yaml.snakeyaml.v1_27.DumperOptions;
import org.yaml.snakeyaml.v1_27.Yaml;
import org.yaml.snakeyaml.v1_27.constructor.AbstractConstruct;
import org.yaml.snakeyaml.v1_27.constructor.Constructor;
import org.yaml.snakeyaml.v1_27.nodes.Node;
import org.yaml.snakeyaml.v1_27.nodes.ScalarNode;
import org.yaml.snakeyaml.v1_27.nodes.Tag;
import org.yaml.snakeyaml.v1_27.representer.Represent;
import org.yaml.snakeyaml.v1_27.representer.Representer;

public class YamlSupport {
    private final EdiSchema schema;

    public YamlSupport(EdiSchema s) {
        this.schema = s;
    }

    public YamlSupport() {
        this(null);
    }

    public static void writeMap(Map<String, Object> map, Writer writer) {
        Yaml yaml = new Yaml(new EdiRepresenter(), new DumperOptions());
        yaml.dump(map, writer);
    }

    public static Map<String, Object> readMap(InputStream is, Charset charset) {
        Yaml yaml = new Yaml();
        return (Map)yaml.load(new InputStreamReader(is, charset));
    }

    public Map<String, Object> readMap(String text) {
        Yaml yaml = new Yaml(new EdiConstructor());
        return (Map)yaml.load(new StringReader(text));
    }

    private class EdiConstructor
    extends Constructor {
        public EdiConstructor() {
            this.yamlConstructors.put(new Tag("!bigdecimal"), new ConstructBigDecimal());
            this.yamlConstructors.put(new Tag("!biginteger"), new ConstructBigInteger());
            this.yamlConstructors.put(new Tag("!structure"), new ConstructStructure());
        }

        private class ConstructStructure
        extends AbstractConstruct {
            private ConstructStructure() {
            }

            @Override
            public Object construct(Node node) {
                return YamlSupport.this.schema.structures().apply((Object)EdiConstructor.this.constructScalar((ScalarNode)node));
            }
        }

        private class ConstructBigInteger
        extends AbstractConstruct {
            private ConstructBigInteger() {
            }

            @Override
            public Object construct(Node node) {
                String value = EdiConstructor.this.constructScalar((ScalarNode)node);
                return new BigInteger(value);
            }
        }

        private class ConstructBigDecimal
        extends AbstractConstruct {
            private ConstructBigDecimal() {
            }

            @Override
            public Object construct(Node node) {
                String value = EdiConstructor.this.constructScalar((ScalarNode)node);
                return new BigDecimal(value);
            }
        }
    }

    private static class EdiRepresenter
    extends Representer {
        public EdiRepresenter() {
            this.representers.put(BigDecimal.class, new RepresentBigDecimal());
            this.representers.put(BigInteger.class, new RepresentBigInteger());
            this.representers.put(Structure.class, new RepresentStructure());
        }

        private class RepresentStructure
        implements Represent {
            private RepresentStructure() {
            }

            @Override
            public Node representData(Object value) {
                return EdiRepresenter.this.representScalar(new Tag("!structure"), ((Structure)value).ident());
            }
        }

        private class RepresentBigInteger
        implements Represent {
            private RepresentBigInteger() {
            }

            @Override
            public Node representData(Object value) {
                return EdiRepresenter.this.representScalar(new Tag("!biginteger"), ((BigInteger)value).toString());
            }
        }

        private class RepresentBigDecimal
        implements Represent {
            private RepresentBigDecimal() {
            }

            @Override
            public Node representData(Object value) {
                return EdiRepresenter.this.representScalar(new Tag("!bigdecimal"), ((BigDecimal)value).toString());
            }
        }
    }
}

