/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.IBM037;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.cobol.ODOIndexer;
import com.mulesoft.flatfile.lexical.parameter.recordparsing.RecordParsingLenient;
import com.mulesoft.flatfile.lexical.parameter.recordparsing.RecordParsingNone;
import com.mulesoft.flatfile.lexical.parameter.recordparsing.RecordParsingSingle;
import com.mulesoft.flatfile.lexical.parameter.recordparsing.RecordParsingStrict;
import com.mulesoft.flatfile.lexical.parameter.recordparsing.validation.IRecordValidator;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import scala.Char;
import scala.collection.immutable.Map;

public abstract class FlatFileLexer
extends LexerBase {
    protected final LineBasedReader typedReader;
    private final Charset encoding;
    protected final boolean allowRaw;
    private final Map<Char, Char> zonedPositiveChars;
    private final Map<Char, Char> zonedNegativeChars;
    private Boolean supportsRaw;
    private byte[] rawTransform;
    protected boolean lastElement;
    protected boolean hasData;
    protected int missingChar;
    protected boolean lineEnd;
    protected IRecordValidator validator;
    protected int leadCount;
    protected int leadOffset;
    protected char[] leadBuffer;
    protected int dependingOnAccumulator;
    protected ODOIndexer odoIndexer;
    protected boolean truncationLimit;
    protected boolean fillDepending;
    protected boolean readingDependingOn;
    protected boolean considerMissingValuesAsNotNull;

    public FlatFileLexer(InputStream is, Charset enc, boolean raw, boolean terminated, boolean longOk, boolean shortOk, int miss, boolean fillDep, Map<Char, Char> zonePos, Map<Char, Char> zoneNeg) {
        super(is, -1);
        if ("IBM037".equals(enc.displayName())) {
            this.encoding = IBM037.charsetInstance;
            this.rawTransform = IBM037.charsetInstance.getReverseReadTransform();
            this.supportsRaw = Boolean.TRUE;
        } else {
            this.encoding = enc;
        }
        this.allowRaw = raw;
        this.missingChar = miss;
        this.fillDepending = fillDep;
        this.zonedPositiveChars = zonePos;
        this.zonedNegativeChars = zoneNeg;
        this.lenient = terminated && longOk && shortOk;
        this.odoIndexer = new ODOIndexer();
        this.typedReader = new LineBasedReader(this.stream, this.encoding);
        this.reader = this.typedReader;
        this.considerMissingValuesAsNotNull = false;
    }

    public Charset getCharset() {
        return this.encoding;
    }

    @Override
    public void discardTo(EdiConstants.ItemType typ) throws IOException {
        if (typ != EdiConstants.ItemType.SEGMENT) {
            throw new IllegalArgumentException("Flat files do not support " + (Object)((Object)typ) + " data type positioning");
        }
        this.nextLine();
    }

    public boolean nextLine() throws IOException {
        this.lastElement = false;
        this.dependingOnAccumulator = 0;
        int chr = this.typedReader.read();
        if (!this.lineEnd) {
            while (!this.validator.checkEndLine(chr)) {
                chr = this.typedReader.read();
            }
        }
        while (chr == 13 || chr == 10) {
            chr = this.typedReader.read();
        }
        if (chr == -1 || this.truncationLimit || !this.hasData && chr == this.missingChar) {
            this.currentType = EdiConstants.ItemType.END;
            return false;
        }
        this.startLine(chr);
        return true;
    }

    public void startLine(int chr) {
        this.lineEnd = false;
        this.leadBuffer[0] = (char)chr;
        this.leadCount = 1;
        this.leadOffset = 0;
        ++this.segmentNumber;
        this.elementNumber = 0;
        this.currentType = EdiConstants.ItemType.SEGMENT;
    }

    public void init() throws IOException {
        int chr = this.reader.read();
        if (chr >= 0) {
            this.startLine(chr);
        } else {
            this.currentType = EdiConstants.ItemType.END;
        }
    }

    public String loadTagField(int start, int length) throws IOException {
        return this.typedReader.loadTagField(start, length);
    }

    public boolean load(int width, int quant) throws IOException {
        this.tokenBuilder.setLength(0);
        boolean result = this.readToken(width, quant, this.lastElement);
        this.currentType = EdiConstants.ItemType.DATA_ELEMENT;
        boolean isNull = this.checkNullValues(this.token());
        return result && !isNull;
    }

    private boolean checkNullValues(String token) {
        char[] chars;
        boolean isNull = true;
        for (char c : chars = token.toCharArray()) {
            boolean bl = isNull = c == this.missingChar;
            if (!isNull) break;
        }
        if (isNull && token.length() > 0 && this.considerMissingValuesAsNotNull) {
            this.tokenBuilder.setLength(0);
            return false;
        }
        return isNull;
    }

    public byte[] rawToken() {
        if (!this.allowRaw) {
            throw new IllegalStateException("Lexer is not configured for raw data access");
        }
        if (this.supportsRaw == null) {
            CharBuffer cbuf = CharBuffer.allocate(256);
            for (int i = 0; i < 256; ++i) {
                cbuf.put((char)i);
            }
            cbuf.position(0);
            ByteBuffer bbuf = this.encoding.encode(cbuf);
            char[] rchars = this.encoding.decode(bbuf).array();
            this.supportsRaw = Boolean.FALSE;
            if (rchars.length == 256) {
                this.supportsRaw = Boolean.TRUE;
                for (int i = 0; i < 256; ++i) {
                    if (rchars[i] == i) continue;
                    this.supportsRaw = Boolean.FALSE;
                    break;
                }
                this.rawTransform = bbuf.array();
            }
        }
        if (this.supportsRaw.booleanValue()) {
            String token = this.token();
            byte[] bytes = new byte[token.length()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = this.rawTransform[token.charAt(i)];
            }
            return bytes;
        }
        throw new IllegalStateException("Raw data is not supported for character encoding " + this.encoding.name());
    }

    protected void parseToken(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            int chr = this.typedReader.read();
            this.validateLength(chr, this.tokenBuilder.length(), length);
            if (this.lineEnd) break;
            this.tokenBuilder.append((char)chr);
        }
    }

    protected void parseLastToken(int length) throws IOException {
        int chr;
        while ((chr = this.typedReader.read()) != -1) {
            this.validateLength(chr, this.tokenBuilder.length(), length);
            if (this.lineEnd) break;
            this.tokenBuilder.append((char)chr);
        }
        this.validateLength(chr, this.tokenBuilder.length(), length);
    }

    public boolean readToken(int length, int quant, boolean isLast) throws IOException {
        if (this.lineEnd) {
            return false;
        }
        this.hasData = false;
        ++this.elementNumber;
        try {
            if (isLast) {
                if (quant > 1) {
                    this.parseDependingOn(length, quant);
                } else {
                    this.parseLastToken(length);
                }
            } else {
                if (quant > 1) {
                    ++this.dependingOnAccumulator;
                }
                this.parseToken(length);
            }
        }
        catch (IOException e) {
            throw new LexicalException(e.getMessage());
        }
        return this.hasData;
    }

    protected void parseDependingOn(int length, int quant) throws IOException {
        ++this.dependingOnAccumulator;
        if (this.dependingOnAccumulator == quant) {
            this.parseLastToken(length);
        } else {
            this.parseToken(length);
        }
    }

    protected void validateLength(int chr, int currentLength, int expectedLength) throws IOException {
        if (currentLength < expectedLength) {
            this.hasData = this.validator.checkShort(chr, currentLength, expectedLength, this.segmentNumber, this.elementNumber);
        } else {
            this.lineEnd = this.validator.checkLong(chr, currentLength, expectedLength, this.segmentNumber, this.elementNumber);
        }
    }

    public void setODOLimitOnCurrentLevel(String level, int limit) {
        this.odoIndexer.openODOStructure(level, limit);
    }

    public void decreaseODOAccum(String level) {
        this.odoIndexer.decreaseAccumulator(level);
    }

    public static FlatFileLexer getRecordParsingImpl(InputStream is, Charset enc, boolean allowRaw, boolean terminatedLines, boolean longOk, boolean shortOk, int miss, boolean fillDepending, Map<Char, Char> zonePos, Map<Char, Char> zoneNeg) {
        if (terminatedLines && longOk && shortOk) {
            return new RecordParsingLenient(is, enc, allowRaw, miss, fillDepending, zonePos, zoneNeg);
        }
        if (!terminatedLines && longOk && shortOk) {
            return new RecordParsingSingle(is, enc, allowRaw, miss, fillDepending, zonePos, zoneNeg);
        }
        if (terminatedLines) {
            return new RecordParsingStrict(is, enc, allowRaw, miss, fillDepending, zonePos, zoneNeg);
        }
        return new RecordParsingNone(is, enc, allowRaw, miss, fillDepending, zonePos, zoneNeg);
    }

    @Override
    public void error(TypeFormat typ, ErrorHandler.ErrorCondition err, String explain) throws LexicalException {
        boolean abort = false;
        String position = "element " + this.elementNumber;
        String text = err.text() + " for data type " + typ.typeCode() + " at " + position + ": '" + this.tokenBuilder + "'";
        if (explain != null) {
            text = text + " (" + explain + ")";
        }
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err, text);
            }
            this.errorHandler.error(typ, err, explain);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                logger.error("Unrecoverable lexer error " + text);
            } else {
                logger.info("Recoverable lexer error " + text);
            }
        }
    }

    public Map<Char, Char> getZonedPositiveChars() {
        return this.zonedPositiveChars;
    }

    public Map<Char, Char> getZonedNegativeChars() {
        return this.zonedNegativeChars;
    }

    public void setLastElement(boolean lastElement) {
        this.lastElement = lastElement;
    }

    public LineBasedReader getTypedReader() {
        return this.typedReader;
    }

    public void setMissingChar(int missingChar) {
        this.missingChar = missingChar;
    }

    public void setConsiderMissingValuesAsNotNull(boolean considerMissingValuesAsNotNull) {
        this.considerMissingValuesAsNotNull = considerMissingValuesAsNotNull;
    }

    public void setTruncationLimit(boolean loaded) {
        this.truncationLimit = loaded;
    }

    public void setReadingDependingOn(boolean reading) {
        this.readingDependingOn = reading;
    }

    public boolean isReadingDependingOn() {
        return this.readingDependingOn;
    }

    public boolean isEndOfDependingOn() {
        return this.odoIndexer.isEndOfODO();
    }

    public void setHasData(boolean hasData) {
        this.hasData = hasData;
    }

    public int getMissingChar() {
        return this.missingChar;
    }

    public class LineBasedReader
    extends FilterReader {
        protected LineBasedReader(InputStream in, Charset enc) {
            super(new BufferedReader(new InputStreamReader(FlatFileLexer.this.stream, enc)));
            FlatFileLexer.this.leadBuffer = new char[128];
            FlatFileLexer.this.leadCount = 0;
        }

        @Override
        public int read() throws IOException {
            if (FlatFileLexer.this.leadOffset < FlatFileLexer.this.leadCount) {
                return FlatFileLexer.this.leadBuffer[FlatFileLexer.this.leadOffset++];
            }
            return super.read();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int actual = 0;
            int remain = len;
            if (FlatFileLexer.this.leadOffset < FlatFileLexer.this.leadCount) {
                int use = Math.min(len, FlatFileLexer.this.leadCount - FlatFileLexer.this.leadOffset);
                System.arraycopy(FlatFileLexer.this.leadBuffer, FlatFileLexer.this.leadOffset, cbuf, off, use);
                FlatFileLexer.this.leadOffset += use;
                actual = use;
                remain -= use;
            }
            if (remain > 0) {
                return actual + super.read(cbuf, off + actual, remain);
            }
            return actual;
        }

        public String loadTagField(int start, int length) throws IOException {
            int limit = start + length;
            if (FlatFileLexer.this.leadBuffer.length < limit) {
                char[] newbuff = new char[limit];
                System.arraycopy(FlatFileLexer.this.leadBuffer, 0, newbuff, 0, FlatFileLexer.this.leadCount);
                FlatFileLexer.this.leadBuffer = newbuff;
            }
            int actual = 0;
            for (int remain = limit - FlatFileLexer.this.leadCount; remain > 0 && (actual = super.read(FlatFileLexer.this.leadBuffer, FlatFileLexer.this.leadCount, remain)) > 0; remain -= actual) {
                FlatFileLexer.this.leadCount += actual;
            }
            if (actual < 0) {
                throw new EOFException("read only " + FlatFileLexer.this.leadCount + " with at least " + limit + " expected");
            }
            return new String(FlatFileLexer.this.leadBuffer, start, length);
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readAheadLimit) {
            throw new UnsupportedOperationException("mark() is not supported");
        }
    }
}

