/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.validation.FormatTypeFunction;
import org.apache.commons.lang3.StringUtils;

public class SignConverterFunction
implements FormatTypeFunction<String, String> {
    @Override
    public String apply(String value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        int signPosition = this.getSignPosition(value);
        return signPosition < 0 ? this.positiveSign(value, typeFormat, handler) : this.negativeSign(value, signPosition, typeFormat, handler);
    }

    protected int getSignPosition(String value) {
        int i = StringUtils.indexOf((CharSequence)value, (int)45);
        return i == 0 || i == value.length() - 1 ? i : -1;
    }

    private String negativeSign(String value, int position, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        String unsigned = StringUtils.substring((String)value, (int)(position == 0 ? 1 : 0), (int)(value.length() - (position > 0 ? 1 : 0)));
        if (!typeFormat.getNumberSign().useMinus()) {
            handler.error(typeFormat, ErrorHandler.ErrorCondition.INVALID_VALUE, "negative value not allowed");
            return unsigned;
        }
        return this.addSign("-", unsigned, typeFormat.getNumberSign().trailingSign());
    }

    private String addSign(String sign, String value, boolean trailingSign) {
        return trailingSign ? value + sign : sign + value;
    }

    private String positiveSign(String value, TypeBaseFormat typeFormat, ErrorHandler handler) {
        return typeFormat.getNumberSign().forceSign() ? this.addSign("+", value, typeFormat.getNumberSign().trailingSign()) : value;
    }
}

