/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;

public class FormatError {
    public static void wrongType(Object obj, ErrorHandler handler, TypeFormat tf) throws LexicalException {
        if (obj == null) {
            handler.error(tf, ErrorHandler.ErrorCondition.WRONG_TYPE, "null value not allowed");
        } else {
            handler.error(tf, ErrorHandler.ErrorCondition.WRONG_TYPE, "incompatible type for supplied value object: " + obj.getClass().getName());
        }
    }

    public static void tooShort(int length, ErrorHandler handler, TypeFormat tf, int minLength) throws LexicalException {
        handler.error(tf, ErrorHandler.ErrorCondition.TOO_SHORT, "effective length " + length + " is less than " + minLength);
    }

    public static void tooLong(int length, ErrorHandler handler, TypeFormat tf, int maxLength) throws LexicalException {
        handler.error(tf, ErrorHandler.ErrorCondition.TOO_LONG, "effective length " + length + " is greater than " + maxLength);
    }

    public static void invalidCharacter(char chr, ErrorHandler handler, TypeFormat tf) throws LexicalException {
        handler.error(tf, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
    }

    public static void noValuePresent(ErrorHandler handler, TypeFormat tf) throws LexicalException {
        handler.error(tf, ErrorHandler.ErrorCondition.INVALID_FORMAT, "no value present");
    }

    public static void invalidInput(ErrorHandler handler, TypeFormat tf) throws LexicalException {
        handler.error(tf, ErrorHandler.ErrorCondition.INVALID_FORMAT, "input does not match format");
    }

    public static void noValueBeforeExp(ErrorHandler handler, TypeFormat tf) throws LexicalException {
        handler.error(tf, ErrorHandler.ErrorCondition.INVALID_FORMAT, "value required before exponent");
    }

    public static void missingRequiredSign(ErrorHandler handler, TypeFormat tf) throws LexicalException {
        handler.error(tf, ErrorHandler.ErrorCondition.INVALID_FORMAT, "missing required sign");
    }

    public static void signNotAllowed(char chr, ErrorHandler handler, TypeFormat tf) throws LexicalException {
        handler.error(tf, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "sign (" + chr + ") not allowed");
    }
}

